package org.unitedfront2.web.controller.mail;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.preparer.PreparerException;
import org.apache.tiles.preparer.ViewPreparer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.communication.Mail;
import org.unitedfront2.domain.communication.MailTable;
import org.unitedfront2.web.WebUtils;

/**
 * [EBWFbgp̃r[vyA[NXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "mailMailWidgetPreparer")
public class MailWidgetPreparer implements ViewPreparer {

    /** 擾Py[W̃Xbh̃ftHg (5) */
    public static final int OFFSET = 5;

    /** O */
    protected final Log logger = LogFactory.getLog(getClass());

    /** [e[u */
    @Autowired private MailTable mailTable;

    @Override
    public void execute(TilesRequestContext tilesContext,
            AttributeContext attributeContext) throws PreparerException {

        Account account = WebUtils.getAccount(tilesContext);
        List<Mail> threads = mailTable.findThreads(account.getId(), 0, OFFSET);
        attributeContext.putAttribute("mails",
            new Attribute(threads));
        attributeContext.putAttribute("unreadMailCount",
            new Attribute(mailTable.countUnreadMail(account.getId())));
    }
}
