package org.unitedfront2.web.controller.mail;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.communication.Mail;
import org.unitedfront2.validation.Validate;
import org.unitedfront2.validation.ValidationException;

/**
 * [쐬ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "mailCreateAction")
public class CreateAction extends MultiAction {

    /** [Ue[u */
    @Autowired
    private SimpleUserTable simpleUserTable;

    /**
     * 悪w肳ĂƂ̌؏s܂B
     *
     * @param context {@link RequestContext}
     * @return ؃G[ȂG[AłȂΐ
     */
    public Event validateTo(RequestContext context) {
        String name = context.getRequestParameters().get("toName");
        if (name != null) {
            // 於w肳Ă
            try {
                Validate.notBlank(name);
            } catch (ValidationException e) {
                context.getMessageContext().addMessage(new MessageBuilder()
                    .error().source("toName").code(e.getCode())
                    .args(e.getArguments()).build());
                return error();
            }

            Mail mail = (Mail) context.getFlowScope().getRequired("mail",
                    Mail.class);
            SimpleUser to = simpleUserTable.findByName(name);
            if (to == null) {
                mail.setTo(new SimpleUser());
                mail.setToName(name);
                context.getMessageContext().addMessage(new MessageBuilder()
                    .error().source("toName")
                    .code("mail.CreateForm.validation.error.toUserNotFound")
                    .build());
                return error();
            }

            mail.setTo(to);
        }
        return success();
    }
}
