package org.unitedfront2.web.controller.community;

import java.util.ArrayList;
import java.util.List;

import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.MultiThreadCommunity;
import org.unitedfront2.domain.communication.SingleThreadCommunity;
import org.unitedfront2.domain.communication.Thread;

/**
 * uO֘Ã[eBeBNXłB
 *
 * @author kurokkie
 *
 */
final class Utils {

    /**
     * R~jeB̋Lꗗ擾܂BeLɂ URI ݒ肳܂B
     *
     * @param community R~jeB
     * @param no Jnԍ
     * @param num L
     * @return LXg
     */
    public static List<Message> findEntries(Community community, int no,
            int num) {
        if (community.getClass() == SingleThreadCommunity.class) {
            SingleThreadCommunity stc = (SingleThreadCommunity) community;
            stc.retrieveEntries(no, num);
            for (Message e : stc.getEntries()) {
                e.setUri(Utils.getPermaLink(stc, e));
            }
            return stc.getEntries();
        } else if (community.getClass() == MultiThreadCommunity.class) {
            MultiThreadCommunity mtc = (MultiThreadCommunity) community;
            List<Message> entries = new ArrayList<Message>();
            for (Thread t : mtc.getThreads()) {
                t.retrieveEntries(no, num);
                for (Message e : t.getEntries()) {
                    e.setUri(Utils.getPermaLink(mtc, t, e));
                }
                entries.addAll(t.getEntries());
            }
            return entries;
        } else {
            String message = "The community type '"
                + community.getClass().getName() + "' not supported.";
            throw new UnsupportedOperationException(message);
        }
    }

    /**
     * Lւ̃p[}N擾܂B
     *
     * @param community R~jeB
     * @param entry L
     * @return p[}N
     */
    public static String getPermaLink(Community community, Message entry) {
        return getPermaLink(community, null, entry);
    }

    /**
     * Lւ̃p[}N擾܂B
     *
     * @param community R~jeB
     * @param thread Xbh
     * @param entry L
     * @return p[}N
     */
    public static String getPermaLink(Community community, Thread thread,
            Message entry) {
        if (community.getClass() == SingleThreadCommunity.class) {
            return "/community/" + community.getCode() + "/entry-"
                + entry.getCode() + ".html";
        } else if (community.getClass() == MultiThreadCommunity.class) {
            if (thread == null) {
                throw new IllegalArgumentException(
                        "The thread must not be null.");
            }
            return "/community/" + community.getCode() + "/" + thread.getId()
                + "/entry-" + entry.getCode() + ".html";
        } else {
            String message = "The community type '" + community.getClass()
                + "' not supported.";
            throw new UnsupportedOperationException(message);
        }
    }

    private Utils() {
        super();
    }
}
