package org.unitedfront2.web.controller.community;

import org.springframework.stereotype.Repository;
import org.springframework.web.util.HtmlUtils;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Thread;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.handler.TitleInterceptor;

/**
 * Xbh{ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "communityThreadViewAction")
public class ThreadViewAction extends MultiAction {

    /**
     * ^Cgt^܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event putTitle(RequestContext context) {
        Thread t = (Thread) context.getFlowScope().getRequired("thread",
                Thread.class);
        context.getFlashScope().put(
                TitleInterceptor.TITLE_CODE_PARAM_NAME,
                "community.ThreadView");
        context.getFlashScope().put(
                TitleInterceptor.TITLE_ARGS_PARAM_NAME,
                new Object[] {
                        HtmlUtils.htmlEscape(t.getOverview().getSubject(
                                WebUtils.getLocale(context))),
                });
        return success();
    }
}
