package org.unitedfront2.web.controller.community;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.util.HtmlUtils;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityTable;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.Thread;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.view.RssView;

/**
 * R~jeB RSS zMpRg[łB
 *
 * @author kurokkie
 *
 */
@Repository(value = "communityThreadRssController")
public class ThreadRssController extends AbstractController {

    /** R~jeBL̕\ (20) */
    public static final int DISPLAY_NUM = 20;

    /** ^Cg̍ő啶 */
    public static final int TITLE_MAX_SIZE = 64;

    /** R~jeBe[u */
    @Autowired
    private CommunityTable communityTable;

    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request,
            HttpServletResponse response) throws Exception {
        String communityCode = ServletRequestUtils.getRequiredStringParameter(
                request, "communityCode");
        int threadId = ServletRequestUtils.getRequiredIntParameter(request,
                "threadId");
        Community c = communityTable.findByCode(communityCode);
        Thread t = c.findThread(threadId);
        return handleRequestInternal(request, c, t);
    }

    private ModelAndView handleRequestInternal(HttpServletRequest request,
            Community community, Thread thread) {
        Locale locale = WebUtils.getLocale(request);
        SyndFeed feed = new SyndFeedImpl();

        // Tv
        feed.setTitle(thread.getOverview().getSubject(locale));
        feed.setLink("/community/" + community.getCode() + "/" + thread.getId()
                + "/index.html");
        feed.setDescription(thread.getOverview().getBody(locale));
        feed.setAuthor(HtmlUtils.htmlEscape(thread.getOwner().getName()));

        // L
        thread.retrieveEntries(0, DISPLAY_NUM);
        List<SyndEntry> sEntries = new ArrayList<SyndEntry>(
                thread.getEntries().size());
        for (Message m : thread.getEntries()) {
            SyndEntry e = new SyndEntryImpl();
            e.setTitle(StringUtils.abbreviate(m.getBody(locale),
                    TITLE_MAX_SIZE));
            e.setLink(Utils.getPermaLink(community, thread, m));
            SyndContent description = new SyndContentImpl();
            description.setType("text/html");
            description.setValue(m.getBody(locale));
            e.setDescription(description);
            e.setPublishedDate(m.getRegistrationDate());
            e.setUpdatedDate(m.getLastUpdateDate());
            sEntries.add(e);
        }
        feed.setEntries(sEntries);

        ModelAndView mav = new ModelAndView(new RssView());
        mav.addObject(RssView.FEED_PARAM_NAME, feed);
        return mav;
    }
}
