package org.unitedfront2.web.controller.account;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.providers
    .UsernamePasswordAuthenticationToken;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.MailAddrAndPassword;
import org.unitedfront2.web.WebUtils;

/**
 * F؂sANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "accountAuthenticationAction")
public class AuthenticationAction extends MultiAction {

    /** F؋@\ */
    @Autowired
    private AuthenticationManager authenticationManager;

    /**
     * F؂s܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     */
    public Event authenticate(RequestContext context) {
        MailAddrAndPassword mailAddrAndPassword
            = (MailAddrAndPassword) context.getFlowScope().getRequired(
                    "mailAddrAndPassword", MailAddrAndPassword.class);
        if (!WebUtils.getAccount(context).getMailAddr().equals(
                mailAddrAndPassword.getMailAddr())) {
            addErrorMessage(context.getMessageContext());
            return error();
        }
        UsernamePasswordAuthenticationToken auth
            = new UsernamePasswordAuthenticationToken(
                    mailAddrAndPassword.getMailAddr(),
                    mailAddrAndPassword.getPassword());
        try {
            authenticationManager.authenticate(auth);
            return success();
        } catch (AuthenticationException e) {
            logger.warn(e.getMessage());
            addErrorMessage(context.getMessageContext());
            return error();
        }
    }

    private void addErrorMessage(MessageContext context) {
        context.addMessage(new MessageBuilder().error()
                .source("mailAddrAndPassword")
                .code("account.AuthenticationAction.error").build());
    }
}
