package org.unitedfront2.web.controller;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.domain.communication.BlogEntry;
import org.unitedfront2.domain.communication.BlogTable;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.MessageTable;
import org.unitedfront2.web.WebUtils;

/**
 * CfbNXʂ̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "indexAction")
public class IndexAction extends MultiAction {

    /** gbvy[WXVԊu (15) */
    public static final int REFLESH_TERM = 60 * 15 * 1000;

    /** Ǘ҃uO̕\L */
    public static final int ADMIN_BLOG_ENTRY_DISPLAY_NUM = 5;

    /** OXV */
    private Date lastRefleshDate;

    /** gbvy[W */
    private Message topPage;

    /** Ǘ҃uO */
    private Blog adminBlog;

    /** Ǘ҂̃uOR[h */
    private String adminBlogCode;

    /** bZ[We[u */
    @Autowired
    private MessageTable messageTable;

    /** uOe[u */
    @Autowired
    private BlogTable blogTable;

    public Event putTopPage(RequestContext context) {
        updateIfNecessary();
        context.getFlashScope().put("topPage", topPage);
        return success();
    }

    public Event putAdminBlog(RequestContext context) {
        updateIfNecessary();
        context.getFlashScope().put("adminBlog", adminBlog);
        return success();
    }

    private void updateIfNecessary() {
        synchronized (logger) {
            if (topPage == null || adminBlog == null
                    || new Date().after(new Date(lastRefleshDate.getTime()
                            + REFLESH_TERM))) {
                topPage = messageTable.findByCode(
                        WebUtils.TOP_PAGE_MESSAGE_CODE);

                adminBlog = blogTable.findByCode(adminBlogCode);
                adminBlog.retrieveEntries(0, ADMIN_BLOG_ENTRY_DISPLAY_NUM);
                lastRefleshDate = new Date();
            }
        }
    }

    public void setAdminBlogCode(String adminBlogCode) {
        this.adminBlogCode = adminBlogCode;
    }
}
