package org.unitedfront2.web.controller;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.EmailForwarding;

/**
 * []ݒ̍XVsANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "emailForwardingAction")
public class EmailForwardingAction extends MultiAction {

    public Event bind(RequestContext context) {
        EmailForwardingSettings emailForwardings = (EmailForwardingSettings)
            context.getFlowScope().getRequired("emailForwardingSettings");
        for (Object key : context.getRequestParameters().asMap().keySet()) {
            Pattern p = Pattern.compile("^settings\\[([\\p{Upper}_]+)\\]$");
            Matcher m = p.matcher(key.toString());
            if (m.matches()) {
                EmailForwarding k = EmailForwarding.valueOf(m.group(1));
                Boolean v = context.getRequestParameters().getRequiredBoolean(
                        key.toString());
                emailForwardings.getSettings().put(k, v);
            }
        }
        return success();
    }
}
