package org.unitedfront2.web;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;

/**
 * fBNgփANZXۂ index.html ֑Jڂ邽߂̃tB^łB
 *
 * @author kurokkie
 *
 */
public class WelcomeFileFilter implements Filter {

    /** OpX */
    private String[] excludePath;

    @Override
    public void destroy() {
        // Do nothing
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response,
            FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest
                && response instanceof HttpServletResponse) {
            HttpServletRequest req = (HttpServletRequest) request;
            HttpServletResponse res = (HttpServletResponse) response;
            if (shouldRedirect(req.getRequestURI().substring(
                    req.getContextPath().length()))) {
                res.sendRedirect(req.getRequestURI() + "index.html");
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private boolean shouldRedirect(String uri) {
        if (uri.endsWith("/")) {
            if (excludePath == null) {
                return true;
            }
            for (String path : excludePath) {
                if (uri.startsWith(path)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void init(FilterConfig filterConfig) {
        String v = filterConfig.getInitParameter("excludePath");
        excludePath = StringUtils.split(v, " \n");
    }
}
