package org.unitedfront2.web;

import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.tiles.context.TilesRequestContext;
import org.springframework.security.Authentication;
import org.springframework.security.context.HttpSessionContextIntegrationFilter;
import org.springframework.security.context.SecurityContext;
import org.springframework.ui.context.Theme;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.Domain;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.Terminal;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.Widget;

/**
 * {@link RequestContext} ̑x郆[eBeBNXłB
 *
 * @author kurokkie
 *
 * @see RequestContextUtils
 */
public final class WebUtils {

    /** Ǘ҂̃[UR[h */
    public static final String ADMIN_USER_CODE = "admin";

    /** Ǘ҂̏dvȂm点bZ[WR[h */
    public static final String SYSTEM_INFORMATION_MESSAGE_CODE = "info";

    /** gbvy[W̃bZ[WR[h */
    public static final String TOP_PAGE_MESSAGE_CODE = "top";

    /** p\P[Xg̃p[^̃ftHg (availableLocales) */
    public static final String AVAILABLE_LOCALES_PARAM_NAME
        = "_availableLocales";

    /** ʃNGXgŒ`郍P[̕ϐ̃ftHg ( _locale ) */
    public static final String LOCALE_PARAM_NAME = "_locale";

    /** ʃNGXgŒ`郍P[̕ϐ̃ftHg ( _theme ) */
    public static final String THEME_PARAM_NAME = "_theme";

    /** NGXgɕۑp[^ ( _terminal ) */
    public static final String TERMINAL_PARAM_NAME = "_terminal";

    /** AJEg̃p[^ (_account) */
    public static final String ACCOUNT_PARAM_NAME = "_account";

    /** [Ũp[^ (_user) */
    public static final String USER_PARAM_NAME = "_user";

    /** [UZbVL[ */
    private static final String USER_SESSION_KEY
        = WebUtils.class.getName() + ".user";

    /** EBWFbgZbVL[ */
    private static final String WIDGET_SESSION_KEY
        = WebUtils.class.getName() + ".widget";

    /**
     * P[擾܂B
     *
     * @param context {@link RequestContext}
     * @return P[
     * @see RequestContextUtils#getLocale(HttpServletRequest)
     */
    public static Locale getLocale(RequestContext context) {
        return RequestContextUtils.getLocale(getRequest(context));
    }

    /**
     * P[擾܂B
     *
     * @param context {@link TilesRequestContext}
     * @return P[
     * @see RequestContextUtils#getLocale(HttpServletRequest)
     */
    public static Locale getLocale(TilesRequestContext context) {
        return RequestContextUtils.getLocale(getRequest(context));
    }

    /**
     * P[擾܂B
     *
     * @param request HTTP NGXg
     * @return P[
     */
    public static Locale getLocale(HttpServletRequest request) {
        return RequestContextUtils.getLocale(request);
    }

    /**
     * e[}擾܂B
     *
     * @param context {@link RequestContext}
     * @return e[}
     * @see RequestContextUtils#getTheme(HttpServletRequest)
     */
    public static Theme getTheme(RequestContext context) {
        return RequestContextUtils.getTheme(getRequest(context));
    }

    /**
     * e[}擾܂B
     *
     * @param context {@link TilesRequestContext}
     * @return e[}
     * @see RequestContextUtils#getTheme(HttpServletRequest)
     */
    public static Theme getTheme(TilesRequestContext context) {
        return RequestContextUtils.getTheme(getRequest(context));
    }

    /**
     * Spring Security ̃OCF؂ɂăZbVɊi[ꂽAJEgIuWFNg擾܂B
     * Ŏ擾AJEgIuWFNǵAf[^ANZXIuWFNg̐ݒ肪sS܂B
     *
     * @param context {@link RequestContext}
     * @return AJEgAAJEgȂꍇ null
     * @throws IllegalArgumentException T[ubgɂANZXłȂ
     */
    public static Account findAccount(RequestContext context)
        throws IllegalArgumentException {

        HttpSession session = getSession(context, false);
        return findAccount(session);
    }

    /**
     * Spring Security ̃OCF؂ɂăZbVɊi[ꂽAJEgIuWFNg擾܂B
     * Ŏ擾AJEgIuWFNǵAf[^ANZXIuWFNg̐ݒ肪sS܂B
     *
     * @param context {@link TilesRequestContext}
     * @return AJEgAAJEgȂꍇ null
     * @throws IllegalArgumentException T[ubgɂANZXłȂ
     */
    public static Account findAccount(TilesRequestContext context)
        throws IllegalArgumentException {

        HttpSession session = getSession(context, false);
        return findAccount(session);
    }

    /**
     * Spring Security ̃OCF؂ɂăZbVɊi[ꂽAJEgIuWFNg擾܂B
     * Ŏ擾AJEgIuWFNǵAf[^ANZXIuWFNg̐ݒ肪sS܂B
     *
     * @param session HTTP ZbV
     * @return AJEgAAJEgȂꍇ null
     */
    public static Account findAccount(HttpSession session) {

        if (session == null) {
            return null;
        }

        Object securityContext = session.getAttribute(
            HttpSessionContextIntegrationFilter.SPRING_SECURITY_CONTEXT_KEY);
        if (securityContext == null) {
            return null;
        }
        Authentication authentication = ((SecurityContext) securityContext)
            .getAuthentication();
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof Account) {
            return (Account) principal;
        } else {
            return null;
        }
    }

    /**
     * Spring Security ̃OCF؂ɂăZbVɊi[ꂽAJEgIuWFNg擾܂B
     * Ŏ擾AJEgIuWFNǵAf[^ANZXIuWFNg̐ݒ肪sS܂B
     *
     * @param session HTTP ZbV
     * @return AJEg
     * @throws IllegalArgumentException AJEgȂ
     */
    public static Account getAccount(HttpSession session)
        throws IllegalArgumentException {
        Account account = findAccount(session);
        if (account == null) {
            throw new IllegalArgumentException("The account is null.");
        }
        return account;
    }

    /**
     * Spring Security ̃OCF؂ɂăZbVɊi[ꂽAJEgIuWFNg擾܂B
     * Ŏ擾AJEgIuWFNǵAf[^ANZXIuWFNg̐ݒ肪sS܂B
     *
     * @param context {@link RequestContext}
     * @return AJEg
     * @throws IllegalArgumentException AJEgȂ
     */
    public static Account getAccount(RequestContext context)
        throws IllegalArgumentException {
        Account account = findAccount(context);
        if (account == null) {
            throw new IllegalArgumentException("The account is null.");
        }
        return account;
    }

    /**
     * Spring Security ̃OCF؂ɂăZbVɊi[ꂽAJEgIuWFNg擾܂B
     * Ŏ擾AJEgIuWFNǵAf[^ANZXIuWFNg̐ݒ肪sS܂B
     *
     * @param context {@link TilesRequestContext}
     * @return AJEg
     * @throws IllegalArgumentException AJEgȂ
     */
    public static Account getAccount(TilesRequestContext context)
        throws IllegalArgumentException {
        Account account = findAccount(context);
        if (account == null) {
            throw new IllegalArgumentException("The account is null.");
        }
        return account;
    }

    /**
     * ZbVɃ[Ui[܂B
     * @param session HTTP ZbV
     * @param user [U
     */
    public static void setUser(HttpSession session, User user) {
        session.setAttribute(USER_SESSION_KEY, user);
    }

    /**
     * ZbVɊi[Ă郆[U擾܂BŎ擾[UIuWFNg̓f[^ANZXIuWF
     * Ng̐ݒ肪sS܂B
     *
     * @param session HTTP ZbV
     * @return [UB[UȂA܂͓nꂽZbV null ̏ꍇ null
     */
    public static SimpleUser findUser(HttpSession session) {
        if (session == null) {
            return null;
        }
        Object obj = session.getAttribute(USER_SESSION_KEY);
        if (obj == null) {
            return null;
        } else if (!(obj instanceof SimpleUser)) {
            String message = "The obj '" + obj + "' is not SimpleUser.";
            throw new IllegalStateException(message);
        } else {
            SimpleUser user = (SimpleUser) obj;
            if (user.getId() == null || user.getCode() == null
                    || user.getName() == null) {
                setUser(session, null);
                return null;
            } else {
                return user;
            }
        }
    }

    /**
     * ZbVɊi[Ă郆[U擾܂BŎ擾[UIuWFNg̓f[^ANZXIuWF
     * Ng̐ݒ肪sS܂B
     *
     * @param context {@link RequestContext}
     * @return [U
     */
    public static SimpleUser findUser(RequestContext context) {
        return findUser(getSession(context, false));
    }

    /**
     * ZbVɊi[Ă郆[U擾܂BŎ擾[UIuWFNg̓f[^ANZXIuWF
     * Ng̐ݒ肪sS܂B
     *
     * @param context {@link TilesRequestContext}
     * @return [U
     */
    public static SimpleUser findUser(TilesRequestContext context) {
        return findUser(getSession(context, false));
    }

    /**
     * ZbVɊi[Ă郆[U擾܂BŎ擾[UIuWFNg̓f[^ANZXIuWF
     * Ng̐ݒ肪sS܂B
     *
     * @param session HTTP ZbV
     * @return [U
     * @throws IllegalArgumentException [UȂ
     */
    public static SimpleUser getUser(HttpSession session)
        throws IllegalArgumentException {
        SimpleUser user = findUser(session);
        if (user == null) {
            throw new IllegalArgumentException("The user is null.");
        }
        return user;
    }

    /**
     * ZbVɊi[Ă郆[U擾܂BŎ擾[UIuWFNg̓f[^ANZXIuWF
     * Ng̐ݒ肪sS܂B
     *
     * @param context {@link RequestContext}
     * @return [U
     * @throws IllegalArgumentException [UȂ
     */
    public static SimpleUser getUser(RequestContext context)
        throws IllegalArgumentException {
        SimpleUser user = findUser(context);
        if (user == null) {
            throw new IllegalArgumentException("The user is null.");
        }
        return user;
    }

    /**
     * ZbVɊi[Ă郆[U擾܂BŎ擾[UIuWFNg̓f[^ANZXIuWF
     * Ng̐ݒ肪sS܂B
     *
     * @param context {@link TilesRequestContext}
     * @return [U
     * @throws IllegalArgumentException [UȂ
     */
    public static SimpleUser getUser(TilesRequestContext context)
        throws IllegalArgumentException {
        SimpleUser user = findUser(context);
        if (user == null) {
            throw new IllegalArgumentException("The user is null.");
        }
        return user;
    }

    /**
     * ZbVɃEBWFbgi[܂B
     *
     * @param session HTTP ZbV
     * @param widgets EBWFbgXg
     */
    public static void setWidgets(HttpSession session, List<Widget> widgets) {
        session.setAttribute(WIDGET_SESSION_KEY, widgets);
    }

    /**
     * ZbVEBWFbg擾܂B
     *
     * @param session HTTP ZbV
     * @return EBWFbgXgBȂA܂͓nꂽZbV null ̏ꍇ null
     */
    public static List<Widget> findWidgets(HttpSession session) {
        if (session == null) {
            return null;
        }
        Object widgets = session.getAttribute(WIDGET_SESSION_KEY);
        if (widgets == null) {
            return null;
        } else {
            return (List<Widget>) widgets;
        }
    }

    /**
     * {@link RequestContext}EBWFbg擾܂B
     *
     * @param context {@link RequestContext}
     * @return EBWFbgXg
     */
    public static List<Widget> findWidgets(RequestContext context) {
        return findWidgets(getSession(context, false));
    }

    /**
     * {@link RequestContext}EBWFbg擾܂B
     *
     * @param context {@link TilesRequestContext}
     * @return EBWFbgXg
     */
    public static List<Widget> findWidgets(TilesRequestContext context) {
        return findWidgets(getSession(context, false));
    }

    /**
     * {@link RequestContext} HTTP ZbV擾܂B
     *
     * @param context HTTP ZbV
     * @return HTTP ZbV
     */
    public static HttpSession getSession(RequestContext context) {
        return getRequest(context).getSession();
    }

    /**
     * {@link RequestContext} HTTP ZbV擾܂B
     *
     * @param context {@link TilesRequestContext}
     * @return HTTP ZbV
     */
    public static HttpSession getSession(TilesRequestContext context) {
        return getRequest(context).getSession();
    }

    /**
     * {@link RequestContext} HTTP ZbV擾܂B
     *
     * @param context {@link RequestContext}
     * @param create ZbVȂꍇVKɐȂ true AłȂ false
     * @return HTTP ZbV
     */
    public static HttpSession getSession(RequestContext context,
            boolean create) {
        return getRequest(context).getSession(create);
    }

    /**
     * {@link RequestContext} HTTP ZbV擾܂B
     *
     * @param context {@link TilesRequestContext}
     * @param create ZbVȂꍇVKɐȂ true AłȂ false
     * @return HTTP ZbV
     */
    public static HttpSession getSession(TilesRequestContext context,
            boolean create) {
        return getRequest(context).getSession(create);
    }

    /**
     * HTTP NGXg擾܂B
     *
     * @param context {@link RequestContext}
     * @return HTTP NGXg
     * @throws IllegalArgumentException T[ubgɂANZXłȂ
     */
    public static HttpServletRequest getRequest(RequestContext context)
        throws IllegalArgumentException {
        Object o = getServletExternalContext(context).getNativeRequest();
        if (o instanceof HttpServletRequest) {
            return (HttpServletRequest) o;
        } else {
            throw new IllegalArgumentException("native request '" + o
                    + "' is not instance of "
                    + HttpServletRequest.class.getName());
        }
    }

    /**
     * HTTP NGXg擾܂B
     *
     * @param context {@link TilesRequestContext}
     * @return HTTP NGXg
     * @throws IllegalArgumentException T[ubgɂANZXłȂ
     */
    public static HttpServletRequest getRequest(TilesRequestContext context)
        throws IllegalArgumentException {

        Object request = context.getRequest();
        if (!(request instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("The TilesRequestContext '"
                + context + "' does not have a HttpServletRequest.");
        }
        return (HttpServletRequest) request;
    }

    /**
     * HTTP X|X擾܂B
     *
     * @param context {@link RequestContext}
     * @return HTTP X|X
     * @throws IllegalArgumentException T[ubgɂANZXłȂ
     */
    public static HttpServletResponse getResponse(RequestContext context)
        throws IllegalArgumentException {
        Object o = getServletExternalContext(context).getNativeResponse();
        if (o instanceof HttpServletResponse) {
            return (HttpServletResponse) o;
        } else {
            throw new IllegalArgumentException("native response '" + o
                    + "' is not instance of "
                    + HttpServletResponse.class.getName());
        }
    }

    /**
     * NGXgReLXg܂̓ZbVɊi[Ă[T܂B
     *
     * @param request {@link HttpServletRequest}
     * @return [AȂ <code>null</code>
     */
    public static Terminal findTerminal(HttpServletRequest request) {
        if (request == null) {
            return null;
        }

        HttpSession session = request.getSession(false);
        if (session != null) {
            Object o = session.getAttribute(TERMINAL_PARAM_NAME);
            if (o instanceof Terminal) {
                // ZbVɊi[Ă΂Ԃ
                return (Terminal) o;
            }
        }

        Object o = request.getAttribute(TERMINAL_PARAM_NAME);
        if (o instanceof Terminal) {
            // NGXgɊi[Ă΂Ԃ
            return (Terminal) o;
        }

        return null;
    }

    /**
     * ZbVɊi[Ă[T܂B
     *
     * @param context {@link RequestContext}
     * @return [AȂ <code>null</code>
     */
    public static Terminal findTerminal(RequestContext context) {
        return findTerminal(getRequest(context));
    }

    /**
     * ZbVɊi[Ă[T܂B
     *
     * @param context {@link TilesRequestContext}
     * @return [AȂ <code>null</code>
     */
    public static Terminal findTerminal(TilesRequestContext context) {
        return findTerminal(getRequest(context));
    }

    /**
     * ZbVɊi[Ă[擾܂B
     *
     * @param request {@link HttpServletRequest}
     * @return [
     * @throws IllegalArgumentException [Ȃ
     */
    public static Terminal getTerminal(HttpServletRequest request)
        throws IllegalArgumentException {

        Terminal terminal = findTerminal(request);
        if (terminal == null) {
            throw new IllegalArgumentException("A terminal not found.");
        }
        return terminal;
    }

    /**
     * ZbVɊi[Ă[擾܂B
     *
     * @param context {@link RequestContext}
     * @return [
     * @throws IllegalArgumentException [Ȃ
     */
    public static Terminal getTerminal(RequestContext context)
        throws IllegalArgumentException {
        return getTerminal(getRequest(context));
    }

    /**
     * ZbVɊi[Ă[擾܂B
     *
     * @param context {@link TilesRequestContext}
     * @return [
     * @throws IllegalArgumentException [Ȃ
     */
    public static Terminal getTerminal(TilesRequestContext context)
        throws IllegalArgumentException {

        return getTerminal(getRequest(context));
    }

    /**
     * {@link ServletExternalContext} Ԃ܂B
     *
     * @param context {@link RequestContext}
     * @return {@link ServletExternalContext}
     * @throws IllegalArgumentException T[ubgɂANZXłȂ
     */
    public static ServletExternalContext getServletExternalContext(
           RequestContext context) throws IllegalArgumentException {

        if (!(context.getExternalContext() instanceof ServletExternalContext)) {
            throw new IllegalArgumentException(
                "context.getExternalContext is not instanceof "
                + "ServletExternalContext.");
        }
        return (ServletExternalContext) context.getExternalContext();
    }

    /**
     * ̃bZ[W擾܂B
     *
     * @param code bZ[WR[h
     * @param args bZ[WR[hւ̈
     * @param request {@link HttpServletRequest}
     * @return bZ[W
     */
    public static String getMessage(String code, Object[] args,
            HttpServletRequest request) {
        return RequestContextUtils.getWebApplicationContext(request)
            .getMessage(code, args, getLocale(request));
    }

    /**
     * ̃bZ[W擾܂B
     *
     * @param code bZ[WR[h
     * @param request {@link HttpServletRequest}
     * @return bZ[W
     */
    public static String getMessage(String code, HttpServletRequest request) {
        return RequestContextUtils.getWebApplicationContext(request)
            .getMessage(code, null, getLocale(request));
    }

    /**
     * ̃bZ[W擾܂B
     *
     * @param code bZ[WR[h
     * @param args bZ[WR[hւ̈
     * @param context {@link RequestContext}
     * @return bZ[W
     */
    public static String getMessage(String code, Object[] args,
            RequestContext context) {
        return RequestContextUtils.getWebApplicationContext(getRequest(context))
            .getMessage(code, args, getLocale(context));
    }

    /**
     * ̃bZ[W擾܂B
     *
     * @param code bZ[WR[h
     * @param context {@link RequestContext}
     * @return bZ[W
     */
    public static String getMessage(String code, RequestContext context) {
        return RequestContextUtils.getWebApplicationContext(getRequest(context))
            .getMessage(code, null, getLocale(context));
    }

    /**
     * ̃bZ[W擾܂B
     *
     * @param code bZ[WR[h
     * @param args bZ[WR[hւ̈
     * @param context {@link TilesRequestContext}
     * @return bZ[W
     */
    public static String getMessage(String code, Object[] args,
            TilesRequestContext context) {
        return RequestContextUtils.getWebApplicationContext(getRequest(context))
            .getMessage(code, args, getLocale(context));
    }

    /**
     * ̃bZ[W擾܂B
     *
     * @param code bZ[WR[h
     * @param context {@link TilesRequestContext}
     * @return bZ[W
     */
    public static String getMessage(String code, TilesRequestContext context) {
        return RequestContextUtils.getWebApplicationContext(getRequest(context))
            .getMessage(code, null, getLocale(context));
    }

    /**
     * hC擾܂B
     *
     * @param <D> ̌^
     * @param map {@link MutableAttributeMap}
     * @param attributeName ϐ
     * @param clazz ̌^
     * @param domainFactory hCt@Ng
     * @return hCIuWFNg
     * @throws IllegalArgumentException 擾IuWFNghCłȂ
     */
    public static <D> D findDomain(MutableAttributeMap map,
            String attributeName, Class<D> clazz, DomainFactory domainFactory)
        throws IllegalArgumentException {
        Object o = map.get(attributeName);
        if (o == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(o.getClass())) {
            String message = "The domain '" + o
                + "' is not assignable from class '" + clazz + "'.";
            throw new IllegalArgumentException(message);
        } else {
            return domainFactory.prototype(o, clazz);
        }
    }

    /**
     * hC擾܂B
     *
     * @param map {@link MutableAttributeMap}
     * @param attributeName ϐ
     * @param clazz hCNX
     * @param domainFactory hCt@Ng
     * @return hCIuWFNg
     * @throws IllegalArgumentException 擾IuWFNghCłȂ
     */
    public static Object findDomain(MutableAttributeMap map,
            String attributeName, DomainFactory domainFactory)
        throws IllegalArgumentException {
        return findDomain(map, attributeName, Domain.class, domainFactory);
    }

    /**
     * hC擾܂B
     *
     * @param <D> ̌^
     * @param map {@link MutableAttributeMap}
     * @param attributeName ϐ
     * @param clazz ̌^
     * @param domainFactory hCt@Ng
     * @return hCIuWFNg
     * @throws IllegalArgumentException 擾IuWFNghCłȂ
     * @throws IllegalArgumentException 擾IuWFNg <code>null</code>
     */
    public static <D> D getDomain(MutableAttributeMap map,
            String attributeName, Class<D> clazz, DomainFactory domainFactory) {
        Object o = map.get(attributeName);
        if (o == null) {
            String message = "The attribute name '" + attributeName
                + "' not found.";
            throw new IllegalArgumentException(message);
        }
        if (!clazz.isAssignableFrom(o.getClass())) {
            String message = "The domain '" + o
                + "' is not assignable from class '" + clazz + "'.";
            throw new IllegalArgumentException(message);
        } else {
            return domainFactory.prototype(o, clazz);
        }
    }

    /**
     * hC擾܂B
     *
     * @param map {@link MutableAttributeMap}
     * @param attributeName ϐ
     * @param domainFactory hCt@Ng
     * @return hCIuWFNg
     * @throws IllegalArgumentException 擾IuWFNghCłȂ
     * @throws IllegalArgumentException 擾IuWFNg <code>null</code>
     */
    public static Object getDomain(MutableAttributeMap map,
            String attributeName, DomainFactory domainFactory) {
        return getDomain(map, attributeName, Domain.class, domainFactory);
    }

    private WebUtils() {
        super();
    }
}
