package org.unitedfront2.validation;

import org.apache.commons.lang.ArrayUtils;

/**
 * ؃G[ɔOłB؃G[bZ[WR[hێ܂B
 *
 * @author kurokkie
 *
 */
public class ValidationException extends IllegalArgumentException {

    /** VAԍ */
    private static final long serialVersionUID = 7057386022092066928L;

    /** ؃G[bZ[WR[h */
    private final String code;

    /** ؃G[bZ[WR[ḧ */
    private final Object[] arguments;

    /**
     * bZ[WR[h܂B
     *
     * @param code ؃G[bZ[WR[h
     * @param arguments ؃G[bZ[WR[ḧ
     */
    public ValidationException(String code, Object[] arguments) {
        super();
        this.code = code;
        this.arguments = ArrayUtils.clone(arguments);
    }

    /**
     * bZ[WR[h܂B
     *
     * @param code ؃G[bZ[WR[h
     * @param arguments ؃G[bZ[WR[ḧ
     * @param defaultMessage ؃G[bZ[W̃ftHg
     * @param cause ̗O
     */
    public ValidationException(String code, Object[] arguments,
            String defaultMessage, Throwable cause) {
        super(defaultMessage, cause);
        this.code = code;
        this.arguments = ArrayUtils.clone(arguments);
    }

    /**
     * bZ[WR[h܂B
     *
     * @param code ؃G[bZ[WR[h
     * @param arguments ؃G[bZ[WR[ḧ
     * @param defaultMessage ؃G[bZ[W̃ftHg
     */
    public ValidationException(String code, Object[] arguments,
            String defaultMessage) {
        super(defaultMessage);
        this.code = code;
        this.arguments = ArrayUtils.clone(arguments);
    }

    /**
     * bZ[WR[h܂B
     *
     * @param code ؃G[bZ[WR[h
     * @param arguments ؃G[bZ[WR[ḧ
     * @param cause ̗O
     */
    public ValidationException(String code, Object[] arguments,
            Throwable cause) {
        super(cause);
        this.code = code;
        this.arguments = ArrayUtils.clone(arguments);
    }

    /**
     * ؃G[bZ[WR[h擾܂B
     * @return ؃G[bZ[WR[h
     */
    public Object[] getArguments() {
        return ArrayUtils.clone(arguments);
    }

    /**
     * ؃G[bZ[WR[ḧ擾܂B
     * @return ؃G[bZ[WR[ḧ
     */
    public String getCode() {
        return code;
    }
}
