package org.unitedfront2.domain.communication;

import java.io.Serializable;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ʂɐ郁bZ[WGgłB
 *
 * @author kurokkie
 *
 */
public class MessageEntry implements Serializable {

    /** VAԍ */
    private static final long serialVersionUID = -5059937089142674038L;

    /**  */
    private String subject;

    /** { */
    private String body;

    public MessageEntry() {
        super();
    }

    public MessageEntry(String subject, String body) {
        super();
        this.subject = subject;
        this.body = body;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
            .append("subject", subject)
            .append("body", body).toString();
    }

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof MessageEntry)) {
            return false;
        }
        MessageEntry castOther = (MessageEntry) other;
        return new EqualsBuilder()
            .append(subject, castOther.subject)
            .append(body, castOther.body).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder()
            .append(subject)
            .append(body).toHashCode();
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }
}
