package org.unitedfront2.domain.communication;

import java.io.Serializable;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.unitedfront2.validation.Validate;
import org.unitedfront2.validation.ValidationException;

/**
 * [IuWFNǧ؃NXłB
 *
 * @author kurokkie
 *
 */
public class MailValidator implements Serializable {

    /** ̍ő啶̃ftHg (64) */
    public static final int DEFAUL_SUBJECT_MAX_LENGTH = 64;

    /** VAԍ */
    private static final long serialVersionUID = 232206026901519596L;

    /** ̍ő啶 */
    private int subjectMaxLength = DEFAUL_SUBJECT_MAX_LENGTH;

    @Override
    public String toString() {
        return new ToStringBuilder(this)
            .append("subjectMaxLength", subjectMaxLength).toString();
    }

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof MailValidator)) {
            return false;
        }
        MailValidator castOther = (MailValidator) other;
        return new EqualsBuilder()
            .append(subjectMaxLength, castOther.subjectMaxLength).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder()
            .append(subjectMaxLength).toHashCode();
    }

    /**
     * ő啶񐔈ȉł邩B
     *
     * @param mail [
     * @throws ValidationException ؗO
     */
    public void validateSubject(Mail mail) throws ValidationException {
        Validate.maxLength(mail.getSubject(), subjectMaxLength);
    }

    public int getSubjectMaxLength() {
        return subjectMaxLength;
    }

    public void setSubjectMaxLength(int subjectMaxLength) {
        this.subjectMaxLength = subjectMaxLength;
    }
}
