package org.unitedfront2.domain.communication;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.unitedfront2.domain.SimpleUser;

/**
 * ՂNXłB
 *
 * @author kurokkie
 *
 */
public class Footmark implements Serializable {

    /** VAԍ */
    private static final long serialVersionUID = -8440276623448202130L;

    /** Ղt[U */
    private SimpleUser simpleUser;

    /** Ղt */
    private Date date;

    public Footmark() {
        super();
    }

    public Footmark(SimpleUser simpleUser, Date date) {
        super();
        this.simpleUser = simpleUser;
        this.date = (Date) date.clone();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
            .append("simpleUser", simpleUser)
            .append("date", date).toString();
    }

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof Footmark)) {
            return false;
        }
        Footmark castOther = (Footmark) other;
        return new EqualsBuilder()
            .append(simpleUser, castOther.simpleUser)
            .append(date, castOther.date).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder()
            .append(simpleUser)
            .append(date).toHashCode();
    }

    public SimpleUser getUser() {
        return simpleUser;
    }

    public void setSimpleUser(SimpleUser simpleUser) {
        this.simpleUser = simpleUser;
    }

    public Date getDate() {
        if (date == null) {
            return null;
        } else {
            return (Date) date.clone();
        }
    }

    public void setDate(Date date) {
        if (date == null) {
            this.date = null;
        } else {
            this.date = (Date) date.clone();
        }
    }
}
