package org.unitedfront2.domain.communication;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.unitedfront2.dao.CommentDao;
import org.unitedfront2.dao.DateDao;
import org.unitedfront2.domain.Deletable;
import org.unitedfront2.domain.Domain;
import org.unitedfront2.domain.Identifiable;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.Storable;

/**
 * Rg\hCfłBPȕs͂ۑ邽߂ɔėpIɗpł܂B
 *
 * @author kurokkie
 *
 */
public class Comment implements Serializable, Storable, Deletable,
        Identifiable<Comment>, Domain {

    /** VAԍ */
    private static final long serialVersionUID = -4237203287741511422L;

    /** ID */
    private Integer id;

    /** Rg𓊍e[U ID */
    private Integer commenterId;

    /** ee */
    private String text;

    /** ŏIXV */
    private Date lastUpdateDate;

    /** Rg񂾃[UiR^[j */
    private transient SimpleUser commenter;

    /** [Ue[u */
    private transient SimpleUserTable simpleUserTable;

    /** f[^ANZXIuWFNg */
    private transient DateDao dateDao;

    /** Rg̃f[^ANZXIuWFNg */
    private transient CommentDao commentDao;

    public Comment() {
        super();
    }

    public Comment(Integer commenterId, String text) {
        super();
        this.commenterId = commenterId;
        this.text = text;
    }

    public Comment(Integer id, Integer commenterId, String text,
            Date lastUpdateDate) {
        this(commenterId, text);
        this.id = id;
        this.lastUpdateDate = (Date) lastUpdateDate.clone();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
            .append("id", id)
            .append("commenterId", commenterId)
            .append("text", text)
            .append("lastUpdateDate", lastUpdateDate).toString();
    }

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof Comment)) {
            return false;
        }
        Comment castOther = (Comment) other;
        return new EqualsBuilder()
            .append(id, castOther.id)
            .append(commenterId, castOther.commenterId)
            .append(text, castOther.text)
            .append(lastUpdateDate, castOther.lastUpdateDate).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder()
            .append(id)
            .append(commenterId)
            .append(text)
            .append(lastUpdateDate).toHashCode();
    }

    /**
     * XVݓōXV܂B
     */
    @Override
    public void store() {
        lastUpdateDate = dateDao.getCurrentDate();
        if (this.id == null) {
            commentDao.register(this);
        } else {
            commentDao.update(this);
        }
    }

    @Override
    public void delete() {
        commentDao.delete(this.id);
    }

    @Override
    public boolean identify(Comment other) {
        if (id == null || other.id == null) {
            return false;
        }
        return id.equals(other.id);
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getCommenterId() {
        return commenterId;
    }

    public void setCommenterId(Integer commenterId) {
        this.commenterId = commenterId;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Date getLastUpdateDate() {
        if (lastUpdateDate == null) {
            return null;
        } else {
            return (Date) lastUpdateDate.clone();
        }
    }

    public void setLastUpdateDate(Date lastUpdateDate) {
        if (lastUpdateDate == null) {
            this.lastUpdateDate = null;
        } else {
            this.lastUpdateDate = (Date) lastUpdateDate.clone();
        }
    }

    public SimpleUser getCommenter() {
        if (commenterId == null) {
            return null;
        } else if (commenter == null && simpleUserTable != null) {
            commenter = simpleUserTable.find(commenterId);
        }
        return commenter;
    }

    public void setCommenter(SimpleUser commenter) {
        this.commenter = commenter;
    }

    public void setSimpleUserTable(SimpleUserTable simpleUserTable) {
        this.simpleUserTable = simpleUserTable;
    }

    public void setCommentDao(CommentDao commentDao) {
        this.commentDao = commentDao;
    }

    public void setDateDao(DateDao dateDao) {
        this.dateDao = dateDao;
    }
}
