package org.unitedfront2.domain.communication;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.unitedfront2.dao.BlogDao;
import org.unitedfront2.domain.Deletable;
import org.unitedfront2.domain.Domain;
import org.unitedfront2.domain.Identifiable;
import org.unitedfront2.domain.Storable;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.accesscontrol.AbstractResource;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.domain.accesscontrol.AccessDeniedException;

/**
 * uO\hCfłB
 *
 * @invariant ${this.writeAccessControl} is
 * {@link org.unitedfront2.domain.accesscontrol.OwnerOnly}
 * @invariant ${this.readAccessControl} is ${this.overview.readAccessControl}
 * @invariant ${this.writeAccessControl} is ${this.overview.writeAccessControl}
 * @invariant uOL݂uO͍폜łȂB
 * @author kurokkie
 *
 */
public class Blog extends AbstractResource implements Serializable,
    Identifiable<Blog>, Storable, Deletable, Domain {

    /** VAԍ */
    private static final long serialVersionUID = 5187863597884559866L;

    /** ID */
    private Integer id;

    /**
     * R[h
     *
     * @invariant ӂȒl
     */
    private String code;

    /** Tv */
    private Message overview;

    /** Rgeɑ΂ANZX */
    private AccessControl commentAccessControl;

    /** uOLXg */
    private transient List<BlogEntry> entries;

    /** uOL */
    private transient Integer count;

    /** uOf[^ANZXIuWFNg */
    private transient BlogDao blogDao;

    public Blog() {
        super();
    }

    public Blog(String code, Message overview, Integer ownerId,
            AccessControl readAccessControl, AccessControl writeAccessControl,
            AccessControl commeAccessControl) {
        super(ownerId, readAccessControl, writeAccessControl);
        this.code = code;
        this.overview = overview;
        this.commentAccessControl = commeAccessControl;
    }

    public Blog(Integer id, String code, Message overview, Integer ownerId,
            AccessControl readAccessControl, AccessControl writeAccessControl,
            AccessControl commeAccessControl) {
        this(code, overview, ownerId, readAccessControl, writeAccessControl,
                commeAccessControl);
        this.id = id;
    }

    @Override
    protected boolean buildEqualsBuilder(EqualsBuilder eb, Object other) {
        if (!(other instanceof Blog)) {
            return false;
        }
        Blog castOther = (Blog) other;
        eb.append(id, castOther.id)
            .append(code, castOther.code)
            .append(overview, castOther.overview);
        if (!super.buildEqualsBuilder(eb, other)) {
            return false;
        }
        eb.append(commentAccessControl, castOther.commentAccessControl);
        return true;
    }

    @Override
    protected void buildHashCodeBuilder(HashCodeBuilder hcb) {
        hcb.append(id).append(code).append(overview);
        super.buildHashCodeBuilder(hcb);
        hcb.append(commentAccessControl);
    }

    @Override
    protected void buildToStringBuilder(ToStringBuilder tsb) {
        tsb.append("id", id).append("code", code).append("overview", overview);
        super.buildToStringBuilder(tsb);
        tsb.append("commentAccessControl", commentAccessControl);
    }

    /**
     * @throws BlogCodeUsedByOtherException w肵R[h̃uOŊɎgpĂ
     */
    @Override
    public void store() throws BlogCodeUsedByOtherException {
        Blog foundByCode = blogDao.findByCode(code);
        if (foundByCode != null && !foundByCode.identify(this)) {
            String message = "The code '" + code
                + "' has already been used by other.";
            logger.warn(message);
            throw new BlogCodeUsedByOtherException(message);
        }
        if (this.id == null) {
            blogDao.register(this);
        } else {
            blogDao.update(this);
        }
    }

    @Override
    public boolean identify(Blog blog) {
        if (id == null) {
            return false;
        }
        return id.equals(blog.getId());
    }

    /**
     * w肵͈͂̃uOL𕜌܂BLԍ͂On܂鐮ŁAID ̍~ɂȂ܂B
     *
     * @param no Jn_ƂȂLԍ
     * @param num 
     */
    public void retrieveEntries(int no, int num) {
        entries = blogDao.findBlogEntries(id, no, num);
    }

    /**
     * uOL𓊍e܂Bw肵uOLۑÃuOƊ֘At܂B
     *
     * @param blogEntry uOL
     */
    public void post(BlogEntry blogEntry) {
        blogEntry.store();
        blogDao.registerBlogEntry(id, blogEntry.getId());
    }

    /**
     * [UœeANZX݂܂B
     *
     * @throws AccessDeniedException ANZX
     */
    public void commentAccess() throws AccessDeniedException {
        commentAccessControl.access(this);
    }

    /**
     * eANZX݂܂B
     *
     * @param userId [U ID
     * @throws AccessDeniedException ANZX
     */
    public void commentAccess(int userId) throws AccessDeniedException {
        commentAccessControl.access(this, userId);
    }

    /**
     * eANZX݂܂B
     *
     * @param user [U
     * @throws AccessDeniedException ANZX
     */
    public void commentAccess(User user) throws AccessDeniedException {
        commentAccessControl.access(this, user);
    }

    /**
     * [UɓeANZX邩肵܂B
     *
     * @return  <code>true</code> AȂ <code>false</code>
     */
    public boolean canComment() {
        try {
            commentAccess();
            return true;
        } catch (AccessDeniedException e) {
            return false;
        }
    }

    /**
     * eANZX邩肵܂B
     *
     * @param userId [U ID
     * @return  <code>true</code> AȂ <code>false</code>
     */
    public boolean canComment(int userId) {
        try {
            commentAccess(userId);
            return true;
        } catch (AccessDeniedException e) {
            return false;
        }
    }

    /**
     * eANZX邩肵܂B
     *
     * @param user [U
     * @return  <code>true</code> AȂ <code>false</code>
     */
    public boolean canComment(User user) {
        try {
            commentAccess(user);
            return true;
        } catch (AccessDeniedException e) {
            return false;
        }
    }

    /**
     * @throws BlogEntryExistException uOL݂Ă
     */
    @Override
    public void delete() throws BlogEntryExistException {
        int count = blogDao.countBlogEntry(id);
        if (count > 0) {
            String message = "The blog [ID=" + id + "] has " + count
                + " entries.";
            logger.warn(message);
            throw new BlogEntryExistException(message);
        }
        blogDao.delete(id);
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Message getOverview() {
        return overview;
    }

    public void setOverview(Message overview) {
        this.overview = overview;
    }

    public AccessControl getCommentAccessControl() {
        return commentAccessControl;
    }

    public void setCommentAccessControl(AccessControl commentAccessControl) {
        this.commentAccessControl = commentAccessControl;
    }

    /**
     * LXg擾܂BĂяoO {@link #retrieveEntries(int, int)} s
     * BsȂꍇASĂ̋LXgԂ܂B
     *
     * @return LXg
     */
    public List<BlogEntry> getEntries() {
        if (entries == null && blogDao != null && getCount() != null) {
            entries = blogDao.findBlogEntries(id, 0, getCount());
        }
        return entries;
    }

    public Integer getCount() {
        if (count == null && blogDao != null && id != null) {
            count = blogDao.countBlogEntry(id);
        }
        return count;
    }

    public Profile getOwnerProfile() {
        if (getOwner() == null) {
            return null;
        } else {
            return getOwner().getProfile();
        }
    }

    public void setBlogDao(BlogDao blogDao) {
        this.blogDao = blogDao;
    }
}
