package org.unitedfront2.domain.accesscontrol;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.unitedfront2.domain.Domain;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.DomainProxy;
import org.unitedfront2.domain.User;

/**
 * ԂύX\ȃANZXNXłB{@link AccessControl#changeTo(Class)} Ă
 * Ã\bh̓ANZXIuWFNgɈϏĂ܂B
 *
 * @author kurokkie
 *
 */
public class AccessControlProxy implements AccessControl, Serializable,
    DomainProxy<AccessControl> {

    /** VAԍ */
    private static final long serialVersionUID = -2484443693088098226L;

    /** ANZXNX */
    private AccessControl accessControl;

    /** hCt@Ng */
    private transient DomainFactory domainFactory;

    public AccessControlProxy() {
        super();
    }

    public AccessControlProxy(AccessControl accessControl) {
        super();
        if (accessControl instanceof AccessControlProxy) {
            this.accessControl
                = ((AccessControlProxy) accessControl).getTarget();
        } else {
            this.accessControl = accessControl;
        }
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
            .append("accessControl", getTarget()).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AccessControl)) {
            return false;
        }
        Object target;
        if (obj instanceof AccessControlProxy) {
            target = ((AccessControlProxy) obj).getTarget();
        } else {
            target = obj;
        }
        return getTarget().equals(target);
    }

    @Override
    public int hashCode() {
        return getTarget().hashCode();
    }

    @Override
    public void access(Resource resource, int userId)
        throws AccessDeniedException {

        getTarget().access(resource, userId);
    }

    @Override
    public void access(Resource resource, User user)
        throws AccessDeniedException {
        getTarget().access(resource, user);
    }

    @Override
    public void access(CopyrightedResource resource, int userId)
        throws AccessDeniedException {

        getTarget().access(resource, userId);
    }

    @Override
    public void access(CopyrightedResource resource, User user)
        throws AccessDeniedException {
        getTarget().access(resource, user);
    }

    @Override
    public void access(Resource resource) throws AccessDeniedException {
        getTarget().access(resource);
    }

    @Override
    public void access(CopyrightedResource resource)
        throws AccessDeniedException {

        getTarget().access(resource);
    }

    @Override
    public boolean identify(AccessControl other) {
        return getTarget().identify(other);
    }

    @Override
    public void store() {
        getTarget().store();
    }

    public void delete() {
        accessControl.delete();
    }

    @Override
    public Integer getId() {
        return getTarget().getId();
    }

    @Override
    public void setId(Integer id) {
        getTarget().setId(id);
    }

    @Override
    public AccessControl changeTo(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        } catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        if (!AccessControl.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("The class name '" + className
                    + "' is not assignable from clazz '" + AccessControl.class
                    + "'.");
        } else {
            return changeTo((Class<? extends AccessControl>) clazz);
        }
    }

    @Override
    public AccessControl changeTo(Class<? extends AccessControl> clazz) {
        Integer id = getId();
        if (!Domain.class.isAssignableFrom(clazz)) {
            String message = "The clazz is not assignable from "
                + Domain.class.getName();
            throw new IllegalArgumentException(message);
        }
        accessControl = domainFactory.prototype(clazz, AccessControl.class);
        setId(id);
        return this;
    }

    @Override
    public Class<? extends AccessControl> getType() {
        return getTarget().getType();
    }

    @Override
    public final AccessControl getTarget() {
        if (accessControl instanceof AccessControlProxy) {
            return ((AccessControlProxy) accessControl).getTarget();
        } else {
            return accessControl;
        }
    }

    public void setAccessControl(AccessControl accessControl) {
        if (accessControl instanceof AccessControlProxy) {
            this.accessControl = ((AccessControlProxy) accessControl)
                .getTarget();
        } else {
            this.accessControl = accessControl;
        }
    }

    public void setDomainFactory(DomainFactory domainFactory) {
        this.domainFactory = domainFactory;
    }
}
