package org.unitedfront2.domain;

import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitedfront2.dao.DateDao;
import org.unitedfront2.dao.SimpleUserDao;

/**
 * [Ue[uW[łB
 *
 * @author kurokkie
 *
 */
public class SimpleUserTable {

    /** O */
    protected final Log logger = LogFactory.getLog(getClass());

    /** ƔfłsԊui~bj */
    private long activeInterSpace = SimpleUser.DEFAULT_ACTIVE_INTERSPACE;

    /** f[^ANZXIuWFNg */
    private transient DateDao dateDao;

    /** [Uf[^ANZXIuWFNg */
    private SimpleUserDao simpleUserDao;

    /**
     * [UCXg[܂B
     *
     * @param user [U
     * @require ${user.id} not null.
     * @require ${user.code} not null.
     * @require ${user.name} not null.
     * @require ${user.id} not exists.
     * @ensure ${this.find(user.id)} equals ${user}
     * @throws UserCodeUsedByOtherException R[hd
     * @throws UserNameUsedByOtherException Od
     */
    public void install(SimpleUser user)
        throws UserCodeUsedByOtherException, UserNameUsedByOtherException {
        if (findByCode(user.getCode()) != null) {
            if (logger.isWarnEnabled()) {
                logger.warn("User code '" + user.getCode()
                    + "' already exists.");
            }
            throw new UserCodeUsedByOtherException(user.getCode());
        }

        if (findByName(user.getName()) != null) {
            if (logger.isWarnEnabled()) {
                logger.warn("User name '" + user.getName()
                    + "' already exists.");
            }
            throw new UserNameUsedByOtherException(user.getName());
        }
        simpleUserDao.register(user);
    }

    /**
     * [U擾܂B
     *
     * @param id ID
     * @return [UAȂ <code>null</code>
     */
    public SimpleUser find(int id) {
        return simpleUserDao.find(id);
    }

    /**
     * w肵R[h[U擾܂B
     *
     * @param code R[h
     * @return [UAȂꍇ <code>null</code>
     */
    public SimpleUser findByCode(String code) {
        return simpleUserDao.findByCode(code);
    }

    /**
     * w肵O[U擾܂B
     *
     * @param name O
     * @return [U
     */
    public SimpleUser findByName(String name) {
        return simpleUserDao.findByName(name);
    }

    /**
     * ̃[U擾܂B̃[UƂ́Aw肵Ȍ̍ŏIANZX[
     * UłB
     *
     * @return [U
     */
    public int countActiveUser() {
        Date currentDate = dateDao.getCurrentDate();
        return simpleUserDao.countByLastAccessDateAfter(new Date(
                currentDate.getTime() - activeInterSpace));
    }

    public void setActiveInterSpace(long activeInterSpace) {
        this.activeInterSpace = activeInterSpace;
    }

    public void setDateDao(DateDao dateDao) {
        this.dateDao = dateDao;
    }

    public void setSimpleUserDao(SimpleUserDao simpleUserDao) {
        this.simpleUserDao = simpleUserDao;
    }
}
