package org.unitedfront2.dao.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.stereotype.Repository;
import org.unitedfront2.dao.FootmarkDao;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.communication.Footmark;

/**
 * {@link FootmarkDao}  JDBC łB
 *
 * @author kurokkie
 *
 */
@Repository(value = "footmarkDao")
public class FootmarkDaoImpl extends DaoSupport
    implements FootmarkDao, RowMapperFactory<Footmark> {

    /** Ճf[^}bp[ */
    private static class FootmarkRowMapper
        implements ParameterizedRowMapper<Footmark> {

        /** [Ue[u */
        private SimpleUserTable simpleUserTable;

        public FootmarkRowMapper(SimpleUserTable simpleUserTable) {
            super();
            this.simpleUserTable = simpleUserTable;
        }

        @Override
        public Footmark mapRow(ResultSet rs, int rowNum) throws SQLException {
            Footmark footmark = new Footmark();
            footmark.setSimpleUser(simpleUserTable.find(rs.getInt("UserId")));
            footmark.setDate(rs.getTimestamp("Date"));
            return footmark;
        }
    }

    /** [Ue[u */
    @Autowired
    private SimpleUserTable simpleUserTable;

    //**************************************************************************
    // RowMapperFactory
    //**************************************************************************
    @Override
    public ParameterizedRowMapper<Footmark> createRowMapper() {
        return new FootmarkRowMapper(simpleUserTable);
    }

    //**************************************************************************
    // FootmarkDao
    //**************************************************************************
    @Override
    public List<Footmark> findByOwnerId(int ownerId) {
        return getSimpleJdbcTemplate().query(
            "SELECT * FROM Footmark WHERE ProfileOwnerId = ? ORDER BY Id DESC",
            createRowMapper(), ownerId);
    }

    @Override
    public void register(int ownerId, int userId) {
        getJdbcTemplate().update(
            "INSERT INTO Footmark(ProfileOwnerId, UserId, Date)"
            + " VALUES(?, ?, NOW())", new Object[] {ownerId, userId});
    }

    @Override
    public void deleteOld(int seconds) {
        getJdbcTemplate().update("DELETE FROM Footmark WHERE "
            + "UNIX_TIMESTAMP(NOW()) - UNIX_TIMESTAMP(Date) >= ?",
            new Object[] {seconds});
    }
}
