package org.unitedfront2.dao.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.stereotype.Repository;
import org.unitedfront2.dao.AccessControlDao;
import org.unitedfront2.domain.Domain;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.accesscontrol.AccessControl;

/**
 * {@link AccessControlDao}  JDBC łB
 *
 * @author kurokkie
 *
 */
@Repository(value = "accessControlDao")
public class AccessControlDaoImpl extends SimpleDaoSupport<AccessControl>
    implements AccessControlDao {

    /** ANZX̃}bsONX */
    private static class AccessControlRowMapper
        implements ParameterizedRowMapper<AccessControl> {

        /** O */
        protected final Log logger = LogFactory.getLog(getClass());

        /** hCt@Ng */
        private DomainFactory domainFactory;

        public AccessControlRowMapper(DomainFactory domainFactory) {
            this.domainFactory = domainFactory;
        }

        @Override
        public AccessControl mapRow(ResultSet rs, int rowNum)
            throws SQLException {
            Class<? extends AccessControl> clazz;
            try {
                clazz = (Class<? extends AccessControl>) Class.forName(
                        rs.getString("Class"));
            } catch (ClassNotFoundException e) {
                logger.error(e.getMessage(), e);
                throw new IllegalStateException(e);
            }
            if (!Domain.class.isAssignableFrom(clazz)) {
                String message = "The clazz " + clazz.getName()
                    + " is not assignable from " + Domain.class.getName();
                throw new IllegalStateException(message);
            }
            AccessControl accessControl = (AccessControl)
                domainFactory.prototype((Class<? extends Domain>) clazz);
            accessControl.setId(rs.getInt("Id"));
            return accessControl;
        }
    }

    //**************************************************************************
    // SimpleDaoSupport
    //**************************************************************************
    @Override
    public ParameterizedRowMapper<AccessControl> createRowMapper() {
        return new AccessControlRowMapper(getDomainFactory());
    }

    @Override
    protected Class<AccessControl> getDomainClass() {
        return AccessControl.class;
    }

    @Override
    protected Map<String, Object> toColumnValueMap(
            AccessControl accessControl) {
        Map<String, Object> map = super.toColumnValueMap(accessControl);
        if (logger.isDebugEnabled()) {
            logger.debug("The access control type is '"
                    + accessControl.getType().getName() + "'.");
        }
        map.put("Class", accessControl.getType().getName());
        return map;
    }
}
