package org.unitedfront2.dao;

import java.util.List;
import java.util.Set;

import org.unitedfront2.domain.SimpleUser;

/**
 * FBf[^ANZXC^[tF[XłB
 *
 * @author kurokkie
 *
 */
public interface FriendDao {

    /**
     * FBo^܂B
     *
     * @param userId [U ID
     * @param friendId FB̃[U ID
     * @require ${userId} exists.
     * @require ${userId} != ${friendId}
     * @require ${this.find(userId, friendId)} is null.
     * @ensure ${this.find(userId, friendId)} not null.
     */
    void register(int userId, int friendId);

    /**
     * ${userId} ̗FB ${friend} 擾܂B
     *
     * @param userId [U ID
     * @param friendId FB̃[U ID
     * @require ${userId} exists.
     * @return [UAFBłȂ <code>null</code>
     */
    SimpleUser find(int userId, int friendId);

    /**
     * ${userId} ̗FBZbg擾܂B
     *
     * @param userId [U ID
     * @return FBZbg
     */
    Set<SimpleUser> findByUserId(int userId);

    /**
     * FBw肵lA_Ŏ擾܂BFBw肵lȉłꍇASĂ̗FB擾
     * B
     *
     * @param userId [U ID
     * @param max ő吔
     * @require ${userId} exists.
     * @require ${max} > 0
     * @return FBZbg
     */
    List<SimpleUser> findRandomly(int userId, int max);

    /**
     * FB폜܂B
     *
     * @param userId [U ID
     * @param friendId FB̃[U ID
     * @require ${userId} exists.
     * @require ${friendId} exists.
     * @ensure ${this.find(userId, friendId)} not null.
     * @ensure ${this.find(userId, friendId)} is null.
     */
    void delete(int userId, int friendId);
}
