package org.unitedfront2.web.flow;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;

public class UriFlowExecutorArgumentHandlerTest {

    @Test
    public void testExtractFlowIdKw\t[IDԂ邩() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/unitedfront2");
        request.setRequestURI("/unitedfront2/dir/page.html");
        ExternalContext context = new ServletExternalContext(new MockServletContext(), request, new MockHttpServletResponse());
        UriFlowExecutorArgumentHandler executor = new UriFlowExecutorArgumentHandler();
        Assert.assertEquals("dir/page-flow", executor.extractFlowId(context));
    }

    @Test
    public void testExtractFlowIdKw\Ȃt[IDԂ邩() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/unitedfront2");
        request.setRequestURI("/unitedfront2/index.html");
        ExternalContext context = new ServletExternalContext(new MockServletContext(), request, new MockHttpServletResponse());
        UriFlowExecutorArgumentHandler executor = new UriFlowExecutorArgumentHandler();
        Assert.assertEquals("index-flow", executor.extractFlowId(context));
    }

    @Test
    public void testExtractFlowIdt@CȂt[IDԂ邩() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/unitedfront2");
        request.setRequestURI("/unitedfront2/dir/");
        ExternalContext context = new ServletExternalContext(new MockServletContext(), request, new MockHttpServletResponse());
        UriFlowExecutorArgumentHandler executor = new UriFlowExecutorArgumentHandler();
        Assert.assertEquals("dir/index-flow", executor.extractFlowId(context));
    }

    @Test
    public void testExtractFlowId[gKw̃t[IDԂ邩() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/unitedfront2");
        request.setRequestURI("/unitedfront2/");
        ExternalContext context = new ServletExternalContext(new MockServletContext(), request, new MockHttpServletResponse());
        UriFlowExecutorArgumentHandler executor = new UriFlowExecutorArgumentHandler();
        Assert.assertEquals("index-flow", executor.extractFlowId(context));
    }
}
