package org.unitedfront2.domain.communication;

import org.junit.Assert;
import org.junit.Test;
import org.unitedfront2.domain.accesscontrol.OwnerOnly;
import org.unitedfront2.domain.accesscontrol.UserOnly;

public class MultiThreadCommunityTest extends AbstractCommunityTest {

    @Override
    protected MultiThreadCommunity createCommunity(int no) {
        MultiThreadCommunity c = domainFactory.prototype(MultiThreadCommunity.class);
        c.setCode("community-" + no);
        c.setOverview(createOverview());
        c.setOwnerId(simpleUser1.getId());
        c.setReadAccessControl(domainFactory.prototype(UserOnly.class));
        c.setWriteAccessControl(domainFactory.prototype(OwnerOnly.class));
        c.setPostAccessControl(domainFactory.prototype(UserOnly.class));
        return c;
    }

    @Test
    public void testChangeTo() throws CommunityCodeUsedByOtherException, CannotChangeCommunityException {
        Community c = createCommunity(0);
        Assert.assertSame(MultiThreadCommunity.class, c.getClass());
        c.store();
        Assert.assertEquals(c, communityTable.find(c.getId()));
        c = c.changeTo(SingleThreadCommunity.class);
        Assert.assertSame(SingleThreadCommunity.class, c.getClass());
        c.store();
        Assert.assertEquals(c, communityTable.find(c.getId()));
    }

    @Test
    public void testCanChangeToVOXbhR~jeBiO͉\() {
        Community c = createCommunity(0);
        Assert.assertTrue(c.canChangeTo(SingleThreadCommunity.class));
    }

    @Test
    public void testRegisterThread() throws CommunityCodeUsedByOtherException, EntryExistException {
        MultiThreadCommunity c = createCommunity(0);
        c.store();
        Thread t = createThread();
        c.registerThread(t);
        c.retrieveThreads();
        Assert.assertSame(1, c.getThreads().size());
        Assert.assertEquals(t, c.getThreads().get(0));

        // Xbh폜ۂ̓mF
        t.delete();
        MultiThreadCommunity data = (MultiThreadCommunity) communityTable.find(
                c.getId());
        data.retrieveThreads();
        Assert.assertTrue(data.getThreads().isEmpty());
    }

    @Test
    public void testIsDeletable폜ł() throws CommunityCodeUsedByOtherException {
        MultiThreadCommunity c = createCommunity(0);
        c.store();
        Assert.assertTrue(c.isDeletable());
    }

    @Test
    public void testIsDeletableLߍ폜łȂ() throws CommunityCodeUsedByOtherException {
        MultiThreadCommunity c = createCommunity(0);
        c.store();
        Thread t = createThread();
        c.registerThread(t);
        Assert.assertFalse(c.isDeletable());
    }

    @Test
    public void testDeletexL܂ōĂSĂ폜() throws CommunityCodeUsedByOtherException, EntryExistException, CannotDeleteCommunityException {
        MultiThreadCommunity c = createCommunity(0);
        c.store();
        Thread t = createThread();
        c.registerThread(t);
        Message e = createEntry();
        t.post(e);
        e.delete();
        t.delete();
        c.delete();
        Assert.assertTrue(true);
    }

    @Test
    public void testGetLastUpdateDateXbhȂꍇ͊Tv̓o^Ԃ() throws CommunityCodeUsedByOtherException {
        MultiThreadCommunity c = createCommunity(0);
        c.store();
        c.retrieveLastUpdateDate();
        Assert.assertEquals(c.getOverview().getRegistrationDate(), c.getLastUpdateDate());
    }

    @Test
    public void testGetLastUpdateDateXbhꍇ̓Xbh̍XVԂ() throws CommunityCodeUsedByOtherException, InterruptedException {
        MultiThreadCommunity c = createCommunity(0);
        c.store();
        java.lang.Thread.sleep(1000);
        Thread t1 = createThread();
        c.registerThread(t1);
        java.lang.Thread.sleep(1000);
        Thread t2 = createThread();
        c.registerThread(t2);
        java.lang.Thread.sleep(1000);
        Message e1 = createEntry();
        t1.post(e1);
        java.lang.Thread.sleep(1000);
        Message e2 = createEntry();
        t2.post(e2);
        c.retrieveLastUpdateDate();
        t2.retrieveLastUpdateDate();
        Assert.assertEquals(t2.getLastUpdateDate(), c.getLastUpdateDate());
    }

    @Test
    public void testRetrieveThreadsiOɌĂяoĂNȂ() {
        MultiThreadCommunity c = createCommunity(0);
        c.retrieveThreads();
        Assert.assertTrue(true);
    }
}
