package org.unitedfront2.domain.communication;

import org.junit.Assert;
import org.junit.Test;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class CommentTest extends TransactionalTestCaseWithInitialData {

    @Test
    public void testRetrieveCommenter[U() {
        Comment comment = domainFactory.prototype(new Comment(simpleUser1.getId(), "Rg̃eXg"));
        comment.store();
        comment.retrieveCommenter();
        Assert.assertEquals(simpleUser1, comment.getCommenter());
    }

    @Test
    public void testRetrieveCommenter() {
        Comment comment = domainFactory.prototype(new Comment(null, "Rg̃eXg"));
        comment.store();
        comment.retrieveCommenter();
        Assert.assertNull(comment.getCommenter());
    }
}
