package org.unitedfront2.domain.accesscontrol;

import org.junit.Test;
import org.unitedfront2.domain.communication.Profile;

public class FriendsOfFriendsOnlyTest extends AccessControlTestSupport {

    @Override
    protected AccessControl getAccessControl() {
        return domainFactory.prototype(FriendsOfFriendsOnly.class);
    }

    @Test(expected=AccessDeniedException.class)
    public void testAccess֓ANZX() throws AccessDeniedException {
        Profile profile = profileTable.get(simpleUser1.getId());
        profile.getReadAccessControl().changeTo(FriendsOfFriendsOnly.class);
        profile.getReadAccessControl().store();
        profile.readAccess();
    }

    @Test(expected=AccessDeniedException.class)
    public void testAccess֗FBłȂ[UANZX() throws AccessDeniedException {
        Profile profile = profileTable.get(simpleUser1.getId());
        profile.getReadAccessControl().changeTo(FriendsOfFriendsOnly.class);
        profile.getReadAccessControl().store();
        profile.readAccess(simpleUser2.getId());
    }

    @Test
    public void testAccess֗FB[UANZX() throws AccessDeniedException {
        Profile profile = profileTable.get(simpleUser1.getId());
        profile.subscribe(simpleUser2.getId());
        profile.allowFriendSubscription(simpleUser2.getId());
        profile.getReadAccessControl().changeTo(FriendsOfFriendsOnly.class);
        profile.getReadAccessControl().store();
        profile.readAccess(simpleUser2.getId());
    }

    @Test
    public void testAccess֗FB̗FB[UANZX() throws AccessDeniedException {
        Profile profile = profileTable.get(simpleUser1.getId());
        profile.subscribe(simpleUser2.getId());
        profile.allowFriendSubscription(simpleUser2.getId());
        Profile profile2 = profileTable.get(simpleUser2.getId());
        profile2.subscribe(simpleUser3.getId());
        profile2.allowFriendSubscription(simpleUser3.getId());
        profile.getReadAccessControl().changeTo(FriendsOfFriendsOnly.class);
        profile.getReadAccessControl().store();
        profile.readAccess(simpleUser3.getId());
    }
}
