package org.unitedfront2.dao.jdbc;

import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Repository;
import org.unitedfront2.dao.SampleDomainDao;
import org.unitedfront2.domain.SampleDomain;

@Repository(value = "sampleDomainDao")
public class SampleDomainDaoImpl extends SimpleDaoSupport<SampleDomain>
    implements SampleDomainDao {

    @Override
    protected Class<SampleDomain> getDomainClass() {
        return SampleDomain.class;
    }

    @Override
    public SampleDomain findByCode(String code) {
        try {
            return getSimpleJdbcTemplate().queryForObject(
                    "SELECT * FROM SampleDomain WHERE Code = ?",
                    createRowMapper(), code);
        } catch (DataAccessException e) {
            if (logger.isInfoEnabled()) {
                logger.info(e.getMessage());
            }
            return null;
        }
    }

    @Override
    public int count() {
        return getSimpleJdbcTemplate().queryForInt(
                "SELECT COUNT(*) FROM SampleDomain");
    }
}
