package org.unitedfront2.dao;

import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.communication.Footmark;
import org.unitedfront2.domain.communication.ProfileTable;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class FootmarkDaoTest
    extends TransactionalTestCaseWithInitialData {

    @Autowired private FootmarkDao footmarkDao;

    @Autowired private SimpleUserDao simpleUserDao;

    @Autowired private ProfileTable profileTable;

    @Override
    public void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        profileTable.install(simpleUser1.getId());
        profileTable.install(simpleUser2.getId());
        profileTable.install(simpleUser3.getId());
    }

    @Test
    public void testFootmark() {
        footmarkDao.register(simpleUser1.getId(), simpleUser2.getId());
        List<Footmark> footmarks = footmarkDao.findByOwnerId(simpleUser1.getId());
        Assert.assertEquals(1, footmarks.size());
        Assert.assertEquals(simpleUser2.getId(), footmarks.get(0).getUser().getId());
    }

    @Test
    public void testFindByOwnerIdȂ() {
        List<Footmark> footmarks = footmarkDao.findByOwnerId(simpleUser1.getId());
        Assert.assertTrue(footmarks.isEmpty());
    }

    @Test
    public void testFindByOwnerId() throws InterruptedException {
        footmarkDao.register(simpleUser1.getId(), simpleUser2.getId());
        Thread.sleep(1000);
        footmarkDao.register(simpleUser1.getId(), simpleUser2.getId());

        List<Footmark> footmarks = footmarkDao.findByOwnerId(simpleUser1.getId());
        Assert.assertEquals(2, footmarks.size());
        Assert.assertEquals(simpleUser2.getId(), footmarks.get(0).getUser().getId());
        Assert.assertEquals(simpleUser2.getId(), footmarks.get(1).getUser().getId());
        Assert.assertTrue(footmarks.get(0).getDate().after(footmarks.get(1).getDate()));
    }

    @Test
    public void testRegister() {
        Assert.assertNotNull(simpleUserDao.find(simpleUser1.getId()));
        Assert.assertNotNull(simpleUserDao.find(simpleUser2.getId()));
        Assert.assertTrue(footmarkDao.findByOwnerId(simpleUser1.getId()).size() == 0);
        footmarkDao.register(simpleUser1.getId(), simpleUser2.getId());
        Assert.assertTrue(footmarkDao.findByOwnerId(simpleUser1.getId()).size() == 1);
    }

    @Test
    public void testDeleteOld폜() throws InterruptedException {
        footmarkDao.register(simpleUser1.getId(), simpleUser2.getId());
        Thread.sleep(1000);
        footmarkDao.deleteOld(1);
        List<Footmark> footmarks = footmarkDao.findByOwnerId(simpleUser1.getId());
        Assert.assertEquals(0, footmarks.size());
    }

    @Test
    public void testDeleteOld폜Ȃ() throws InterruptedException {
        footmarkDao.register(simpleUser1.getId(), simpleUser2.getId());
        footmarkDao.deleteOld(1);
        List<Footmark> footmarks = footmarkDao.findByOwnerId(simpleUser1.getId());
        Assert.assertEquals(1, footmarks.size());
    }
}
