<%@ page language="java" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/view/Include.jsp" %>

<tiles:importAttribute name="mails"/>
<tiles:importAttribute name="unreadMailCount"/>

<div class="widget">
  <h3><spring:message code="mail"/></h3>
  <div class="align-center">
  <c:choose>
    <c:when test="${unreadMailCount > 0}"><spring:message code="mail.Index.unreadMailCount" arguments="${unreadMailCount}"/></c:when>
    <c:otherwise><spring:message code="mail.Index.unreadMailCount.zero"/></c:otherwise>
  </c:choose>
  </div>
  <ul class="noneMarker">
    <c:forEach var="mail" items="${mails}">
    <li class="margin-top<uf2:hasUnreadMail user="${_user}" mail="${mail}"> strong</uf2:hasUnreadMail>">
      <div class="smaller thin">
        <div class="float-left"><uf2:formatDate date="${mail.sentDate}"/></div>
        <div class="float-right"><uf2:user user="${mail.from}"/></div>
      </div>
      <div class="float-clear">
        <a href="<c:url value="/mail/${mail.code}/index.html"/>"><c:out value="${mail.subject}"/><c:if test="${empty mail.subject}"><spring:message code="nonTitle"/></c:if></a>
      </div>
    </li>
    </c:forEach>
  </ul>
</div>
