package org.unitedfront2.web.tags.message;

import java.io.IOException;
import java.io.Writer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.commons.lang.StringUtils;
import org.springframework.web.util.HtmlUtils;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.MessageEntry;
import org.unitedfront2.web.WebUtils;

/**
 * bZ[W̌o͂^OCułBP[ɉēK؂ȌI܂B
 *
 * @author kurokkie
 *
 */
public class MessageSubjectTag extends TagSupport {

    /** VAԍ */
    private static final long serialVersionUID = -3448950705491400110L;

    /** bZ[W */
    private Message message;

    @Override
    public int doStartTag() throws JspException {
        MessageEntry messageEntry = message.getEntryMap().get(WebUtils
                .getLocale((HttpServletRequest) pageContext.getRequest()));
        if (messageEntry == null
                || StringUtils.isBlank(messageEntry.getSubject())) {
            messageEntry = message.getRequiredEntry();
        }
        Writer out = pageContext.getOut();
        try {
            out.write(HtmlUtils.htmlEscape(messageEntry.getSubject()));
        } catch (IOException e) {
            throw new JspException(e);
        }
        return SKIP_BODY;
    }

    public void setMessage(Message message) {
        this.message = message;
    }
}
