package org.unitedfront2.web.tags;

import java.io.IOException;
import java.io.Writer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.unitedfront2.web.WebUtils;

/**
 * y[WO\^OłB
 *
 * @author kurokkie
 *
 */
public class PagingTag extends TagSupport {

    /** VAԍ */
    private static final long serialVersionUID = 4487861702012807554L;

    /** ftHg̃y[W̕ϐ (page) */
    public static final String DEFAULT_PAGE_PARAM_NAME = "page";

    /** ftHg̕\ (20) */
    public static final int DEFAULT_DISPLAY_COUNT = 20;

    /** y[W̕ϐ */
    private String pageParamName = DEFAULT_PAGE_PARAM_NAME;

    /** \ */
    private int displayCount = DEFAULT_DISPLAY_COUNT;

    /**  */
    private Integer count;

    /** URL */
    private String url;

    /**
     * Web Flow ̏ԂێȂ <code>true</code> AȂȂ <code>false</code>
     */
    private boolean flow;

    @Override
    public int doStartTag() throws JspException {
        if (!(pageContext.getRequest() instanceof HttpServletRequest)) {
            return SKIP_BODY;
        }
        HttpServletRequest request = (HttpServletRequest) pageContext
            .getRequest();
        ApplicationContext appContext = WebApplicationContextUtils
            .getRequiredWebApplicationContext(pageContext.getServletContext());
        int page = ServletRequestUtils.getIntParameter(request, pageParamName,
                0);

        boolean disabledPrevious = page == 0;
        boolean disabledNext;
        if (count != null) {
            disabledNext = (page + 1) * displayCount >= count;
        } else {
            disabledNext = false;
        }

        if (!disabledPrevious || !disabledNext) {
            Writer writer = pageContext.getOut();
            try {
                writer.write("<div>");

                // previous
                writer.write("<div class=\"float-left\">");
                writeForm(writer, page - 1, "&lt;", appContext.getMessage(
                        "toPrevious", null, WebUtils.getLocale(request)),
                        disabledPrevious);
                writer.write("</div>");

                // next
                writer.write("<div class=\"float-right\">");
                writeForm(writer, page + 1, "&gt;", appContext.getMessage(
                        "toNext", null, WebUtils.getLocale(request)),
                        disabledNext);
                writer.write("</div>");

                writer.write("<div class=\"float-clear\"></div>");

                writer.write("</div>");
            } catch (IOException e) {
                throw new JspException(e);
            }
        }
        return SKIP_BODY;
    }

    private void writeForm(Writer writer, int page, String submitValue,
            String title, boolean disabled) throws IOException {
        writer.write("<form action=\"");
        writer.write(Utils.createUrl(url, pageContext));
        writer.write("\" method=\"POST\" class=\"float-left\">\n");
        if (flow) {
            writer.write("<input type=\"hidden\" name=\"_eventId\" "
                    + "value=\"paging\"/>\n");
            writer.write("<input type=\"hidden\" name=\"_flowExecutionKey\" "
                    + "value=\"" + pageContext.findAttribute("flowExecutionKey")
                    + "\"/>\n");
        }
        writer.write("<input type=\"hidden\" name=\"page\" value=\"");
        writer.write(Integer.toString(page));
        writer.write("\"/>\n");
        writer.write("<input type=\"submit\" value=\"");
        writer.write(submitValue);
        writer.write("\" title=\"");
        writer.write(title);
        writer.write("\" class=\"paging\"");
        if (disabled) {
            writer.write(" disabled=\"disabled\"");
        }
        writer.write("\n/>");
        writer.write("</form>\n");
    }

    public void setPageParamName(String pageParamName) {
        this.pageParamName = pageParamName;
    }

    public void setDisplayCount(int displayCount) {
        this.displayCount = displayCount;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setFlow(boolean flow) {
        this.flow = flow;
    }
}
