package org.unitedfront2.web.flow;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

import org.springframework.core.io.Resource;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.definition.registry.FlowDefinitionResource;
import org.springframework.webflow.engine.builder.xml
    .XmlFlowRegistryFactoryBean;

/**
 * WXg̊Kw\IDƂĕ\ {@link XmlFlowRegistryFactoryBean} łB
 *
 * @author kurokkie
 *
 */
public class HierarchyXmlFlowRegistryFactoryBean extends
        XmlFlowRegistryFactoryBean {

    /** [gWXg̃ftHg */
    public static final String DEFAULT_ROOT_REGISTRY = "/WEB-INF/flows";

    /**
     * Temporary holder for flow definition locations.
     *
     * eNXƓl̃vpeBłB
     */
    private Resource[] locations;

    /**
     * Temporary holder for flow definitions configured using a property map.
     *
     * eNXƓl̃vpeBłB
     */
    private Properties flowDefinitions;

    /**
     * A map that contains a map (java.util.Map) of flow attributes keyed by
     * flow id (String).
     *
     * eNXƓl̃vpeBłB
     */
    private Map flowAttributes;

    /** [gWXg */
    private String rootRegistry = DEFAULT_ROOT_REGISTRY;

    /**
     * {@link #setFlowLocations(Resource[])} Őݒ肵t[ݒt@CꂼɁA
     * Kwꂽt[IDUAo^܂B {@link #setFlowDefinitions(Properties)}
     * ɐݒ肵t[ݒt@C͂̂܂ܓo^܂B
     *
     *@{@link #setFlowLocations(Resource[])} ŊUIĎ`̗L܂B
     * [gWXg: /WEB-INF/flows
     * t[ݒt@Cւ̃pX: /WEB-INF/flows/dir1/dir2/sample-flow.xml
     * t[ID: dir1/dir2/sample-flow
     *
     * @param registry WXg
     */
    @Override
    protected void doPopulate(FlowDefinitionRegistry registry) {
        addFlowDefinitionLocations();
        addFlowDefinitionsFromProperties();
        getXmlFlowRegistrar().registerFlowDefinitions(registry);
    }

    /**
     * Add configured flow definition locations to the flow definition
     * registrar.
     */
    private void addFlowDefinitionLocations() {
        if (locations != null) {
            for (int i = 0; i < locations.length; i++) {
                String flowId = conventionalFlowId(locations[i]);
                getXmlFlowRegistrar().addResource(
                    new FlowDefinitionResource(flowId, locations[i],
                        getFlowAttributes(flowId)));
            }
        }
    }

    /**
     * Add flow definitions configured using a property map to
     * the flow definition registrar.
     */
    private void addFlowDefinitionsFromProperties() {
        if (flowDefinitions != null) {
            Iterator it = flowDefinitions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry) it.next();
                String flowId = (String) entry.getKey();
                String location = (String) entry.getValue();
                Resource resource = getFlowServiceLocator().getResourceLoader()
                    .getResource(location);
                getXmlFlowRegistrar().addResource(
                    new FlowDefinitionResource(flowId, resource,
                        getFlowAttributes(flowId)));
            }
        }
    }

    /**
     * Returns the flow attributes to be assigned to the flow with given id.
     * Returns null if no attributes should be assigned.
     *
     * eNX̃\bhփANZXłȂ߁ATuNXœl̎sĂB
     */
    private AttributeMap getFlowAttributes(String flowId) {
        if (flowAttributes != null) {
            Map attributes = (Map) flowAttributes.get(flowId);
            if (attributes != null) {
                return new LocalAttributeMap(attributes);
            }
        }
        return null;
    }

    /**
     * Kwꂽt[ID쐬܂B
     *
     * @param resource {@link ServletContextResource}
     * @return t[ID
     * @see #doPopulate(FlowDefinitionRegistry)
     */
    protected String conventionalFlowId(Resource resource) {
        if (!(resource instanceof ServletContextResource)) {
            throw new IllegalArgumentException("Resource '" + resource
                + "' is not " + ServletContextResource.class.getName());
        }
        ServletContextResource servletContextResource
            = (ServletContextResource) resource;
        String path = servletContextResource.getPath();
        if (!path.startsWith(rootRegistry)) {
            throw new IllegalArgumentException("Resource '" + resource
                + "' must be start with rootRegistry '" + rootRegistry + "'.");
        }
        String flowId = path.substring(rootRegistry.length() + 1);
        int extensionIndex = flowId.lastIndexOf('.');
        if (extensionIndex != -1) {
            return flowId.substring(0, extensionIndex);
        } else {
            return flowId;
        }
    }

    /**
     * eNXGetter\bhփANZXłȂ߁ATuNXœl̎sĂ܂B
     *
     * @param locations the resource locations
     * @see XmlFlowRegistryFactoryBean#setFlowLocations(Resource[])
     */
    @Override
    public void setFlowLocations(Resource[] locations) {
        this.locations = locations.clone();
    }

    /**
     * eNXGetter\bhփANZXłȂ߁ATuNXœl̎sĂ܂B
     *
     * @param flowDefinitions the flow definitions, defined within a properties
     *     map
     * @see XmlFlowRegistryFactoryBean#setFlowDefinitions(Properties)
     */
    @Override
    public void setFlowDefinitions(Properties flowDefinitions) {
        this.flowDefinitions = flowDefinitions;
    }

    /**
     * eNXGetter\bhփANZXłȂ߁ATuNXœl̎sĂ܂B
     *
     * @param flowAttributes the flow attributes, keyed by flow id
     * @see XmlFlowRegistryFactoryBean#setFlowAttributes(Map)
     */
    @Override
    public void setFlowAttributes(Map flowAttributes) {
        this.flowAttributes = flowAttributes;
    }

    /**
     * [gWXgݒ肵܂B
     * @param rootRegistry [gWXg
     */
    public void setRootRegistry(String rootRegistry) {
        this.rootRegistry = rootRegistry;
    }
}
