package org.unitedfront2.web.controller.profile;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.communication.Mail;
import org.unitedfront2.domain.communication.Profile;
import org.unitedfront2.domain.communication.ProfileTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.SubflowUtils;
import org.unitedfront2.web.controller.mail.CreateAction;
import org.unitedfront2.web.flow.AccessDeniedException;
import org.unitedfront2.web.flow.PageNotFoundException;

/**
 * FB\݋@\̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "profile.friendSubscribeAction")
public class FriendSubscribeAction extends MultiAction {

    /** \ݐ̃[U ID */
    private static final String TO_PARAM_NAME
        = FriendSubscribeAction.class.getName() + ".toId";

    /** [Ue[u */
    @Autowired private SimpleUserTable simpleUserTable;

    /** vtB[e[u */
    @Autowired private ProfileTable profileTable;

    /** hCt@Ng */
    @Autowired private DomainFactory domainFactory;

    /**
     * s܂BNɑ΂Đ\݂̂At[ŋL܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws PageNotFoundException p[^s
     * @throws AccessDeniedException gƗFBɂȂ낤Ƃ
     *     vtB[ɑ΂ANZXȂAɗFB
     */
    public Event init(RequestContext context) throws PageNotFoundException,
        AccessDeniedException {
        String userCode = context.getRequestParameters().get("userCode");
        if (userCode == null) {
            String message = "The parameter 'to' must not be null.";
            logger.warn(message);
            throw new PageNotFoundException(context, this, message);
        }

        User user = WebUtils.getUser(context);
        Profile profile = profileTable.findByOwnerCode(userCode);
        if (profile == null) {
            // ݂ȂvtB[
            String message = "The user [Code='" + userCode + "'] not found.";
            logger.warn(message);
            throw new PageNotFoundException(context, this, message);
        }

        try {
            profile.readAccess(user.getId());
        } catch (
                org.unitedfront2.domain.accesscontrol.AccessDeniedException e) {
            logger.error(e);
            throw new AccessDeniedException(context, this, e);
        }

        if (user.getId().equals(profile.getOwnerId())) {
            // gƗFBɂȂ낤Ƃ
            String message = "Not allow to become a friend myself.";
            logger.warn(message);
            throw new AccessDeniedException(context, this, message);
        }

        profile.retrieveFriends();
        if (SimpleUser.exists(profile.getFriends(), user)) {
            // ɗFB
            String message = "The user [ID=" + profile.getOwnerId()
                + "] is already your friend.";
            logger.warn(message);
            throw new AccessDeniedException(context, this, message);
        }

        SimpleUser to = simpleUserTable.find(profile.getOwnerId());
        context.getFlowScope().put("to", to);
        return success();
    }

    /**
     * FB\݂󂯕tĂꍇ͂̂܂ܗFBɁAłȂΐ\݃tH[ցB
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event decide(RequestContext context) {
        SimpleUser u = WebUtils.getUser(context);
        u.retrieveProfile();
        u.getProfile().retrieveSubscriptingUsers();
        SimpleUser to = (SimpleUser) context.getFlowScope().getRequired("to",
                SimpleUser.class);
        if (SimpleUser.exists(u.getProfile().getSubscriptingUsers(), to)) {
            // FB\󂯂Ăꍇ͂̂܂ܗFB
            return result("done");
        } else {
            // FB\tH[
            return result("form");
        }
    }

    /**
     * \݃tH[̑OB
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event initMailForm(RequestContext context) {
        SimpleUser to = (SimpleUser) context.getFlowScope().getRequired("to",
                SimpleUser.class);

        Mail mail = domainFactory.prototype(Mail.class);
        mail.setToId(to.getId());
        mail.setTo(to);
        mail.setSubject(WebUtils.getMessage("profile.FriendSubscribe", null,
                context));

        // for create mail subflow
        context.getFlowScope().put("mail", mail);
        context.getFlowScope().put(TO_PARAM_NAME, to);
        context.getFlowScope().put(CreateAction.UNMODIFIABLE_TO_PARAM_NAME, to);
        context.getFlowScope().put(
                SubflowUtils.PAGE_TITLE_CODE_PARAM_NAME,
                "profile.FriendSubscribe");
        context.getFlowScope().put(
                SubflowUtils.PAGE_DESCRIPTION_CODE_PARAM_NAME,
                "profile.View.FriendSubscribe.description");
        context.getFlowScope().put(
                SubflowUtils.FORM_SUBMIT_CODE_PARAM_NAME,
                "profile.FriendSubscribe.submit");
        return success();
    }

    /**
     * FB̐\݂s܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event subscribe(RequestContext context) {
        User me = WebUtils.getUser(context);
        User to = (User) context.getFlowScope().get(TO_PARAM_NAME);
        Profile profile = profileTable.get(me.getId());
        profile.subscribe(to.getId());
        context.getRequestScope().put("to", to);
        return success();
    }
}
