package org.unitedfront2.web.controller.mail;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.accesscontrol.AccessDeniedException;
import org.unitedfront2.domain.communication.Mail;
import org.unitedfront2.domain.communication.MailTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.flow.PageNotFoundException;
import org.unitedfront2.web.handler.TitleInterceptor;

/**
 * ̃[Xbh\ANVłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "mail.viewAndReplyAction")
public class ViewAndReplyAction extends SendMailActionSupport {

    /** [̃[ev[g (mail.Mail-mail) */
    public static final String MAIL_MAIL_TEMPLATE_NAME = "mail.Mail-mail";

    /** [Ue[u */
    @Autowired private SimpleUserTable simpleUserTable;

    /** [e[u */
    @Autowired private MailTable mailTable;

    /** hCt@Ng */
    @Autowired private DomainFactory domainFactory;

    @Override
    protected void initAction() {
        super.initAction();
        setMailTemplateName(MAIL_MAIL_TEMPLATE_NAME);
    }

    /**
     * [Xbh\܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws PageNotFoundException w肵[Ȃ
     */
    public Event view(RequestContext context) throws PageNotFoundException {

        Account account = WebUtils.findAccount(context);

        // [
        String code = context.getRequestParameters().get("code");
        Mail thread;
        try {
            thread = findThreadByCode(code, account.getId());
        } catch (AccessDeniedException e) {
            logger.info("Move to access denied page. Reason: '"
                + e.getMessage() + "'");
            // ANZXۂA[Uɂ URL ԈĂ悤Ɍ
            throw new org.unitedfront2.web.flow.PageNotFoundException(context,
                    this, e);
        }

        if (thread == null) {
            String message = "The mail code '" + code + "' not found.";
            logger.warn(message);
            throw new org.unitedfront2.web.flow.PageNotFoundException(context,
                    this);
        }
        Mail.retrieveUsers(thread.asList());

        // vtB[{ł邩
        SimpleUser user = WebUtils.getUser(context);
        boolean canReadProfile = false;
        SimpleUser other = thread.other(user);
        if (other != null) {
            // [UłȂ
            other.retrieveProfile();
            if (other.getProfile() != null) {
                canReadProfile = other.getProfile().canRead(user.getId());
            }
        }

        context.getFlowScope().put("thread", thread);
        context.getRequestScope().put("thread", thread);
        context.getRequestScope().put("canReadProfile", canReadProfile);
        context.getRequestScope().put(TitleInterceptor.TITLE_ARGS_PARAM_NAME,
            new Object[] {thread.getSubject()});
        return success();
    }

    private Mail findThreadByCode(String code, int userId)
        throws AccessDeniedException {

        Mail mail = mailTable.findThreadByCode(code);
        if (mail == null) {
            return null;
        }
        User user = simpleUserTable.get(userId);
        if (!mail.getToId().equals(user.getId())
                && !mail.getFromId().equals(user.getId())) {
            String message = "The user '" + user
                + "' cannot access to the mail code '" + code + "'.";
            throw new AccessDeniedException(message);
        }
        mail.readAll(user.getId());
        return mail;
    }

    /**
     * [ɕԐM܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event reply(RequestContext context) {
        Mail thread = (Mail) context.getFlowScope().get("thread");
        Account account = WebUtils.findAccount(context);
        Mail mail = (Mail) getFormObject(context);
        try {
            mail = reply(thread.getId(), account.getId(), mail.getBody());
        } catch (AccessDeniedException e) {
            logger.info("Move to access denied page. Reason: '"
                    + e.getMessage() + "'");
            throw new org.unitedfront2.web.flow.AccessDeniedException(context,
                    this, e);
        }

        if (isSendMail() && mailTable.isForwarding(mail.getToId())) {
            // e[M
            mail.retrieveToMailAddr();
            mail.retrieveFrom();
            context.getRequestScope().put(MAIL_PARAM_NAME, mail);
            doSendMail(context);
        }

        return success();
    }

    private Mail reply(int parentId, int fromId, String body)
        throws AccessDeniedException {

        SimpleUser from = simpleUserTable.get(fromId);
        Mail parentMail = mailTable.get(parentId);
        if (!parentMail.getToId().equals(from.getId())
                && !parentMail.getFromId().equals(from.getId())) {
            String message = "The user '" + from
                + "' cannot access to the parentMail ID '" + parentId + "'.";
            throw new AccessDeniedException(message);
        }
        Integer toId = parentMail.getToId();
        if (parentMail.getToId().equals(from.getId())) {
            toId = parentMail.getFromId();
        }
        Mail mail = domainFactory.prototype(new Mail(toId, from.getId(),
                parentMail.getSubject(), body));
        mail.send(parentMail.getId());
        return mail;
    }
}
