package org.unitedfront2.web.controller.mail;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.communication.Mail;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.SubflowUtils;
import org.unitedfront2.web.handler.TitleInterceptor;

/**
 * ₢킹̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "mail.inquiryAction")
public class InquiryAction extends AbstractAction {

    /** et[n{̃vpeB */
    public static final String SUBJECT_PARAM_NAME = "subject";

    /** [Ue[u */
    @Autowired private SimpleUserTable simpleUserTable;

    /** hCt@Ng */
    @Autowired private DomainFactory domainFactory;

    /**
     * Ǘ҃[Ut[XR[vɐݒ肵܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    @Override
    protected Event doExecute(RequestContext context) {
        SimpleUser admin = simpleUserTable.getByCode(WebUtils.ADMIN_USER_CODE);
        Mail mail = domainFactory.prototype(Mail.class);
        mail.setToId(admin.getId());
        mail.setTo(admin);
        Object subject = context.getFlowScope().get(SUBJECT_PARAM_NAME);
        if (subject != null) {
            mail.setSubject(subject.toString());
        }
        context.getFlowScope().put("mail", mail);
        context.getFlowScope().put("unmodifiableTo", admin);
        context.getFlowScope().put(SubflowUtils.PAGE_TITLE_CODE_PARAM_NAME,
                "mail.InquiryForm");
        context.getFlowScope().put(
                SubflowUtils.PAGE_DESCRIPTION_CODE_PARAM_NAME,
                "mail.InquiryForm.description");
        context.getRequestScope().put(TitleInterceptor.TITLE_CODE_PARAM_NAME,
            "mail.InquiryForm");
        return success();
    }
}
