package org.unitedfront2.web.controller.blog;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;
import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.domain.communication.BlogValidator;
import org.unitedfront2.validation.SpringValidatorSupport;
import org.unitedfront2.validation.ValidationException;

/**
 * uO쐬/ҏW̓͒l؃NXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "blog.formValidator")
public class FormValidator
    extends SpringValidatorSupport<BlogValidator, Blog> {

    @Override
    protected void doValidate(Blog blog, Errors errors) {
        try {
            getOriginalValidator().validateCode(blog);
        } catch (ValidationException e) {
            rejectValue("code", e, errors);
        }
    }

    @Override
    @Autowired
    public void setOriginalValidator(BlogValidator originalValidator) {
        super.setOriginalValidator(originalValidator);
    }
}
