package org.unitedfront2.web.controller.blog;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.domain.communication.BlogTable;
import org.unitedfront2.web.flow.PageNotFoundException;

/**
 * uOLXg\ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "blog.entryIndexAction")
public class EntryIndexAction extends AbstractAction {

    /** uOe[u */
    @Autowired private BlogTable blogTable;

    @Override
    protected Event doExecute(RequestContext context)
        throws PageNotFoundException {

        // uO̎擾
        Blog blog = Utils.findAndReadAccessByCode(context, this, blogTable,
                "code");

        // L҂̕
        blog.retrieveOwner();
        blog.getOwner().retrieveProfile();
        blog.retrieveEntries();

        context.getRequestScope().put("blog", blog);

        return success();
    }
}
