package org.unitedfront2.domain.communication;

import java.io.Serializable;
import java.util.List;

import org.unitedfront2.domain.accesscontrol.AccessControl;

/**
 * PXbh^̃R~jeBłB
 *
 * @invariant ${this.thread.overview} equals ${this.overview}
 * @invariant ${this.thread.ownerId} equals ${this.ownerId}
 * @invariant ${this.thread.readAccessControl} equals ${this.readAccessControl}
 * @invariant ${this.thread.writeAccessControl} equals
 * ${this.writeAccessControl}
 * @invariant ${this.thread.postAccessControl} equals ${this.postAccessControl}
 *
 * @author kurokkie
 *
 */
public class SingleThreadCommunity extends AbstractCommunity
    implements Serializable {

    /** VAԍ */
    private static final long serialVersionUID = -1131508329939121582L;

    /** Xbh */
    private transient Thread thread;

    public SingleThreadCommunity() {
        super();
    }

    public SingleThreadCommunity(Integer id, String code, Message overview,
            Integer ownerId, AccessControl readAccessControl,
            AccessControl writeAccessControl, AccessControl postAccessControl) {
        super(id, code, overview, ownerId, readAccessControl,
                writeAccessControl, postAccessControl);
    }

    public SingleThreadCommunity(String code, Message overview,
            Integer ownerId, AccessControl readAccessControl,
            AccessControl writeAccessControl, AccessControl postAccessControl) {
        super(code, overview, ownerId, readAccessControl, writeAccessControl,
                postAccessControl);
    }

    /** XbhȂ΍폜łB */
    @Override
    public boolean isDeletable() {
        retrieveThread();
        retrieveCount();
        return getCount() == 0;
    }

    /** VKo^ɂ́AXbhɓo^܂B */
    @Override
    public void store() throws CommunityCodeUsedByOtherException {
        if (getId() == null) {
            // VKo^
            super.store();
            registerThread();
        } else {
            // XV
            super.store();
            List<Thread> threads = getCommunityDao().findThreads(getId());
            if (threads.isEmpty()) {
                registerThread();
            }
        }
    }

    private void registerThread() {
        Thread t = getDomainFactory().prototype(Thread.class);
        t.setOverview(getOverview());
        t.setOwnerId(getOwnerId());
        t.setReadAccessControl(getReadAccessControl());
        t.setWriteAccessControl(getWriteAccessControl());
        t.setPostAccessControl(getPostAccessControl());
        t.store();
        getCommunityDao().registerThread(getId(), t.getId());
        this.thread = t;
    }

    @Override
    public void delete() throws CannotDeleteCommunityException {
        retrieveThread();
        try {
            thread.delete();
        } catch (EntryExistException e) {
            throw new CannotDeleteCommunityException(e);
        }
        super.delete();
    }

    @Override
    public <C extends Community> boolean canChangeTo(Class<C> clazz) {
        if (clazz == SingleThreadCommunity.class) {
            return true;
        }
        if (clazz == MultiThreadCommunity.class) {
            return true;
        } else {
            String message = "The community type '" + clazz.getClass().getName()
                 + "' not supported.";
            logger.error(message);
            throw new UnsupportedOperationException(message);
        }
    }

    @Override
    protected <C extends Community> C doChangeTo(Class<C> clazz) {
        if (clazz == SingleThreadCommunity.class) {
            return (C) this;
        }
        if (clazz == MultiThreadCommunity.class) {
            return (C) getDomainFactory().prototype(
                    new MultiThreadCommunity(getId(), getCode(), getOverview(),
                            getOwnerId(), getReadAccessControl(),
                            getWriteAccessControl(), getPostAccessControl()));
        } else {
            String message = "The community type '" + clazz.getClass().getName()
                 + "' not supported.";
            logger.error(message);
            throw new UnsupportedOperationException(message);
        }
    }

    /**
     * LȂΊTv̓o^AL݂΁AŐV̓o^Ԃ܂B
     */
    @Override
    public void retrieveLastUpdateDate() {
        retrieveThread();
        retrieveEntries(0, 1);
        if (this.thread.getEntries().isEmpty()) {
            setLastUpdateDate(getOverview().getLastUpdateDate());
        } else {
            setLastUpdateDate(thread.getEntries().get(0).getRegistrationDate());
        }
    }

    /** Xbh𕜌܂Bɕς݂̏ꍇ͉܂B */
    public void retrieveThread() {
        if (thread == null) {
            List<Thread> threads = getCommunityDao().findThreads(getId());
            if (threads.isEmpty()) {
                String message = "Thread not found.";
                logger.error(message);
                throw new IllegalStateException(message);
            } else if (threads.size() == 1) {
                this.thread = threads.get(0);
            } else {
                String message = "This community is multi thread.";
                logger.error(message);
                throw new IllegalStateException(message);
            }
        }
    }

    /**
     * SĂ̋L̒҂Ƃ̃vtB[𕜌܂BO
     * {@link #retrieveEntries(int, int)} ĂяoKv܂B
     */
    public void retrieveEntryAuthors() {
        for (Message e : getEntries()) {
            e.retrieveAuthor();
            if (e.getAuthor() != null) {
                e.getAuthor().retrieveProfile();
            }
        }
    }

    public int getThreadId() {
        return this.thread.getId();
    }

    public List<Message> getEntries() {
        return thread.getEntries();
    }

    public void post(Message message) {
        thread.post(message);
    }

    /**
     * Xbhێ鑍LԂ܂B
     *
     * @return L
     */
    public int getCount() {
        return thread.getCount();
    }

    public void retrieveCount() {
        if (thread == null) {
            retrieveThread();
        }
        thread.retrieveCount();
    }

    public void retrieveEntries(int no, int num) {
        if (thread == null) {
            retrieveThread();
        }
        thread.retrieveEntries(no, num);
    }

    public Thread getThread() {
        return thread;
    }
}
