package org.unitedfront2.domain.communication;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;

import org.unitedfront2.dao.ProfileDao;
import org.unitedfront2.dao.SelfIntroductionDao;
import org.unitedfront2.dao.SimpleFindable;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.Installer;
import org.unitedfront2.domain.SimpleTableModule;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.domain.accesscontrol.OwnerOnly;
import org.unitedfront2.domain.accesscontrol.Public;

/**
 * vtB[e[uW[łBFBƑՂ̊ǗS܂B
 *
 * @author kurokkie
 *
 */
public class ProfileTable extends SimpleTableModule<Profile>
    implements Installer {

    /** vtB[f[^ANZXIuWFNg */
    private ProfileDao profileDao;

    /** ȏЉf[^ANZXIuWFNg */
    private SelfIntroductionDao selfIntroductionDao;

    /** [Ue[u */
    private SimpleUserTable simpleUserTable;

    /** bZ[Wt@Ng */
    private DomainFactory domainFactory;

    @Override
    protected SimpleFindable<Profile> getSimpleDao() {
        return profileDao;
    }

    /**
     * vtB[CXg[܂B
     *
     * @param userId [U ID
     * @require ${userId} exists.
     * @ensure vtB[f[^o^
     * @ensure ȏЉo^
     */
    @Override
    public void install(int userId) {
        SimpleUser user = simpleUserTable.find(userId);

        Profile profile = domainFactory.prototype(Profile.class);
        profile.setOwnerId(user.getId());
        profile.setReadAccessControl(domainFactory.prototype(Public.class));
        profile.setWriteAccessControl(domainFactory.prototype(OwnerOnly.class));
        profileDao.register(profile);

        installSelfIntroduction(userId, profile.getReadAccessControl(),
                profile.getWriteAccessControl());
    }

    private void installSelfIntroduction(int userId,
            AccessControl readAccessControl, AccessControl writeAccessControl) {
        Message selfIntroduction = domainFactory.prototype(Message.class);
        selfIntroduction.setOwnerId(userId);
        selfIntroduction.setAuthorId(userId);
        selfIntroduction.setReadAccessControl(readAccessControl);
        selfIntroduction.setWriteAccessControl(writeAccessControl);
        selfIntroduction.setEntryMap(new HashMap<Locale, MessageEntry>());
        try {
            selfIntroduction.store();
        } catch (MessageCodeUsedByOtherException e) {
            throw new IllegalStateException(e);
        }
        selfIntroductionDao.register(userId, selfIntroduction.getId());
    }

    /**
     * ŜɌJĂvtB[̏L҃Xg_Ɏ擾܂B
     *
     * @return vtB[L҃Xg
     */
    public List<SimpleUser> getPublicProfileOwnersRandomly() {
        return profileDao.findPublicProfileOwnersRandomly();
    }

    /**
     * ŜɌJĂvtB[̏L҃Xgw萔_Ɏ擾܂B
     *
     * @param max ő匏
     * @return vtB[L҃Xg
     */
    public List<SimpleUser> getPublicProfileOwnersRandomly(int max) {
        return profileDao.findPublicProfileOwnersRandomly(max);
    }

    /**
     * L҂̃[UR[hvtB[擾܂B
     *
     * @param ownerCode L҂̃[UR[h
     * @return vtB[
     * @ensure ${this.find(ownerId)} equals ${return}
     */
    public Profile findByOwnerCode(String ownerCode) {
        return profileDao.findByOwnerCode(ownerCode);
    }

    public void setProfileDao(ProfileDao profileDao) {
        this.profileDao = profileDao;
    }

    public void setSelfIntroductionDao(
            SelfIntroductionDao selfIntroductionDao) {
        this.selfIntroductionDao = selfIntroductionDao;
    }

    public void setSimpleUserTable(SimpleUserTable simpleUserTable) {
        this.simpleUserTable = simpleUserTable;
    }

    public void setDomainFactory(DomainFactory domainFactory) {
        this.domainFactory = domainFactory;
    }
}
