package org.unitedfront2.domain.communication;

import java.io.Serializable;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.unitedfront2.validation.Validate;
import org.unitedfront2.validation.ValidationException;

/**
 * R~jeB̌؃NXłB
 *
 * @author kurokkie
 *
 */
public class CommunityValidator implements Serializable {

    /** R[h̐K\̃ftHg ([0-9a-z]+) */
    public static final String DEFAULT_CODE_REGEX = "[0-9a-z]+";

    /** R[hő啶񒷂̃ftHg (32) */
    public static final int DEFAULT_CODE_MAX_LENGTH = 32;

    /** VAԍ */
    private static final long serialVersionUID = -5703500021756639101L;

    /** R[h̐K\ */
    private String codeRegex = DEFAULT_CODE_REGEX;

    /** R[h̍ő啶 */
    private int codeMaxLength = DEFAULT_CODE_MAX_LENGTH;

    /** R~jeBe[u */
    private transient CommunityTable communityTable;

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof CommunityValidator)) {
            return false;
        }
        CommunityValidator castOther = (CommunityValidator) other;
        return new EqualsBuilder()
            .append(codeRegex, castOther.codeRegex)
            .append(codeMaxLength, castOther.codeMaxLength).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder()
            .append(codeRegex)
            .append(codeMaxLength).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
            .append("codeRegex", codeRegex)
            .append("codeMaxLength", codeMaxLength).toString();
    }

    /**
     * R[h؂܂B<p>
     *
     * ؓe
     * <ul>
     *   <li>K{</li>
     *   <li>ő啶</li>
     *   <li>K\</li>
     *   <li></li>
     * </ul>
     *
     * @param community R~jeB
     * @throws ValidationException {@link ValidationException}
     */
    public void validateCode(Community community) throws ValidationException {
        String code = community.getCode();
        Validate.notBlank(code);
        Validate.maxLength(code, codeMaxLength);
        Validate.match(code, codeRegex);
        Community found = communityTable.findByCode(code);
        if (found != null && !community.identify(found)) {
            throw new ValidationException(
                    "community.CommunityCodeUsedByOtherException", null,
                    "The code '" + code + "' is used by other.");
        }
    }

    public String getCodeRegex() {
        return codeRegex;
    }

    public void setCodeRegex(String codeRegex) {
        this.codeRegex = codeRegex;
    }

    public int getCodeMaxLength() {
        return codeMaxLength;
    }

    public void setCodeMaxLength(int codeMaxLength) {
        this.codeMaxLength = codeMaxLength;
    }

    public void setCommunityTable(CommunityTable communityTable) {
        this.communityTable = communityTable;
    }
}
