package org.unitedfront2.dao.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.stereotype.Repository;
import org.unitedfront2.dao.WidgetDao;
import org.unitedfront2.domain.Widget;

/**
 * {@link WidgetDao}  JDBC łB
 *
 * @author kurokkie
 *
 */
@Repository(value = "widgetDao")
public class WidgetDaoImpl extends DaoSupport implements WidgetDao {

    /** EBWFbg}bp[ */
    private static class WidgetMappdr
        implements ParameterizedRowMapper<Widget> {

        @Override
        public Widget mapRow(ResultSet rs, int rowNum) throws SQLException {
            return Widget.valueOf(rs.getString("Widget"));
        }
    }

    @Override
    public void register(int userId, List<Widget> widgets) {
        for (Widget widget : widgets) {
            getJdbcTemplate().update(
                "INSERT INTO Widget(UserId, Widget) VALUES(?, ?)",
                new Object[] {userId, widget.toString()});
        }
    }

    @Override
    public List<Widget> find(int userId) {
        return getSimpleJdbcTemplate().query(
            "SELECT Widget FROM Widget WHERE UserId = ? ORDER BY Sequence",
            new WidgetMappdr(), userId);
    }

    @Override
    public void update(int userId, List<Widget> widgets) {
        delete(userId);
        register(userId, widgets);
    }

    private void delete(int userId) {
        getJdbcTemplate().update("DELETE FROM Widget WHERE UserId = ?",
                new Object[] {userId});
    }
}
