package org.unitedfront2.domain;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.dao.SimpleFindable;
import org.unitedfront2.domain.SampleDomain.State;
import org.unitedfront2.test.TableModuleTestCaseSupport;

public class SampleDomainTableTest extends TableModuleTestCaseSupport<SampleDomain> {

    @Autowired private SampleDomainTable sampleDomainTable;

    @Override
    protected SampleDomain createDomain() {
        return domainFactory.prototype(new SampleDomain("test", 12.345, "This is example.", false,
                new Timestamp(DateUtils.truncate(new Date(),
                        Calendar.SECOND).getTime()), State.AVAILABLE));
    }

    @Override
    protected SimpleTableModule<SampleDomain> getTableModule() {
        return sampleDomainTable;
    }

    @Override
    protected SimpleFindable<SampleDomain> getSimpleDao() {
        return sampleDomainTable.getSimpleDao();
    }
}
