package org.unitedfront2.dao;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.domain.accesscontrol.Public;
import org.unitedfront2.domain.accesscontrol.UserOnly;
import org.unitedfront2.test.DaoTestCaseSupport;

public class AccessControlDaoTest extends DaoTestCaseSupport<AccessControl> {

    @Autowired private AccessControlDao accessControlDao;

    @Override
    protected AccessControl createTestDomain() {
        return domainFactory.prototype(Public.class);
    }

    @Override
    protected void editTestDomain(AccessControl accessControl) {
        accessControl.changeTo(UserOnly.class);
    }

    @Override
    protected SimpleFindable<AccessControl> getDao() {
        return accessControlDao;
    }
}
