<%@ page language="java" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/view/Include.jsp" %>

<uf2:pc>
<div>
  <div>
    <!-- Top Page -->
    <h2><uf2:messageSubject message="${topPage}"/></h2>
    <p><uf2:messageBody message="${topPage}"/></p>
    <security:authorize ifAllGranted="ROLE_ADMIN">
    <div class="align-right">
      <a href="<c:url value="/update.html"/>"><spring:message code="Index.updateLink"/></a>
    </div>
    </security:authorize>
  </div>

  <div>
    <!-- Admin Blog -->
    <div>
      <!-- Overview -->
      <h3><uf2:messageSubject message="${adminBlog.overview}"/></h3>
      <p><uf2:messageBody message="${adminBlog.overview}"/></p>
    </div>
    <div>
      <!-- Entries -->
      <c:forEach var="entry" items="${adminBlog.entries}">
        <div>
          <!-- Entry -->
          <div class="smaller thin"><uf2:formatDate date="${entry.registrationDate}" detail="true"/></div>
          <h4 class="underline"><a href="<c:url value="/blog/${adminBlog.code}/entry-${entry.code}.html"/>"><uf2:messageSubject message="${entry.entry}"/></a></h4>
          <p><uf2:messageBody message="${entry.entry}"/></p>
          <div class="align-right smaller">
            <a href="<c:url value="/blog/${adminBlog.code}/entry-${entry.code}.html#comment"/>"><spring:message code="comment"/> (${entry.commentCount})</a>
          </div>
        </div>
      </c:forEach>
      <div class="align-center">
        <a href="<c:url value="/blog/${adminBlog.code}/index.html"/>"><spring:message code="Index.adminBlog.more"/></a>
      </div>
    </div>
  </div>
</div>
</uf2:pc>
