package org.unitedfront2.web.view;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;

import java.io.IOException;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.View;

/**
 * RSS p̃r[łB
 *
 * @author kurokkie
 *
 */
public class RssView implements View {

    /** tB[h̕ϐ */
    public static final String FEED_PARAM_NAME = RssView.class.getName()
        + ".feed";

    /** VXe URL ̕ϐ (_systemUrl) */
    public static final String SYSTEM_URL_PARAM_NAME = "_systemUrl";

    /** tB[h^Cv (rss_2.0) */
    public static final String FEED_TYPE = "rss_2.0";

    /** GR[h^Cv (UTF-8) */
    public static final String ENCODING = "UTF-8";

    /** ^Cgɂړ ([United Front] ) */
    public static final String TITLE_PREFIX = "United Front - ";

    /** O */
    protected final Log logger = LogFactory.getLog(getClass());

    /**
     * @return 'text/xml'
     */
    @Override
    public String getContentType() {
        return "text/xml";
    }

    /**
     * tB[ho͂܂B
     *
     * @param model f
     * @param request {@link HttpServletRequest}
     * @param response {@link HttpServletResponse}
     * @throws IOException {@link IOException}
     * @throws FeedException {@link FeedException}
     */
    @Override
    public void render(Map model, HttpServletRequest request,
            HttpServletResponse response) throws IOException, FeedException {
        Object o = model.get(FEED_PARAM_NAME);
        if (!(o instanceof SyndFeed)) {
            String message = "The object '" + o + "' not instance of "
                + SyndFeed.class.getSimpleName();
            logger.error(message);
            throw new IllegalStateException(message);
        }
        SyndFeed feed = (SyndFeed) o;
        decorate(feed, request);
        SyndFeedOutput output = new SyndFeedOutput();
        output.output(feed, response.getWriter());
    }

    public void decorate(SyndFeed feed, HttpServletRequest request) {
        feed.setFeedType(FEED_TYPE);
        feed.setEncoding(ENCODING);
        feed.setTitle(TITLE_PREFIX + feed.getTitle());
        Object o = request.getAttribute(SYSTEM_URL_PARAM_NAME);
        if (!(o instanceof String)) {
            String message = "The system url [paramName='"
                + SYSTEM_URL_PARAM_NAME + "'] not found.";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        String systemUrl = (String) o;
        feed.setLink(systemUrl + feed.getLink());
        for (Object e : feed.getEntries()) {
            SyndEntry entry = (SyndEntry) e;
            entry.setLink(systemUrl + entry.getLink());
        }
    }
}
