package org.unitedfront2.web.tags;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.commons.lang.time.DateUtils;
import org.unitedfront2.web.WebUtils;

/**
 * w肵ݓPȓȂ玞ԂANxłꍇ͌AȊOȂN\
 * B
 *
 * @author kurokkie
 *
 */
public class FormatDateTag extends TagSupport {

    /** VAԍ */
    private static final long serialVersionUID = 4759905947927372043L;

    /**  */
    private Date date;

    /** ڍׂȕ\ɂꍇ <code>true</code> AȂꍇ <code>false</code> */
    private boolean detail;

    @Override
    public int doStartTag() throws JspException {
        if (date == null) {
            return SKIP_BODY;
        }

        Locale locale;
        if (pageContext.getRequest() instanceof HttpServletRequest) {
            locale = WebUtils.getLocale(
                    (HttpServletRequest) pageContext.getRequest());
        } else {
            locale = Locale.getDefault();
        }

        Date currentDate = new Date();
        if (DateUtils.truncate(date, Calendar.DATE).equals(
                DateUtils.truncate(currentDate, Calendar.DATE))) {
            print(new SimpleDateFormat("HH:mm", locale).format(date));
            return SKIP_BODY;
        }

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(Calendar.YEAR);

        Calendar currentCalendar = Calendar.getInstance();
        currentCalendar.setTime(currentDate);
        int currentYear = calendar.get(Calendar.YEAR);

        if (year == currentYear && detail) {
            print(new SimpleDateFormat("MM/dd HH:mm", locale).format(date));
        } else if (year == currentYear) {
            print(new SimpleDateFormat("MM/dd", locale).format(date));
        } else if (detail) {
            print(new SimpleDateFormat("yyyy/MM/dd HH:mm",
                    locale).format(date));
        } else {
            print(new SimpleDateFormat("yyyy/MM/dd", locale).format(date));
        }
        return SKIP_BODY;
    }

    private void print(String formatDate) throws JspException {
        Writer out = pageContext.getOut();
        try {
            out.write(formatDate);
        } catch (IOException e) {
            throw new JspException(e);
        }
    }

    public void setDate(Date date) {
        if (date == null) {
            this.date = null;
        } else {
            this.date = (Date) date.clone();
        }
    }

    public void setDetail(boolean detail) {
        this.detail = detail;
    }
}
