package org.unitedfront2.web.flow;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.util.WebUtils;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.executor.support
    .RequestPathFlowExecutorArgumentHandler;

/**
 * URIt[ID𐶐 {@link RequestPathFlowExecutorArgumentHandler} łB
 *
 * @author kurokkie
 *
 */
public class UriFlowExecutorArgumentHandler extends
    RequestPathFlowExecutorArgumentHandler {

    /** ftHg̃t[ID̐ڔ */
    public static final String DEFAULT_FLOW_ID_SUFFIX = "-flow";

    /** ftHg̃CfbNXt[ID */
    public static final String DEFAULT_INDEX_FLOW_ID = "index";

    /** Oo͕ϐ */
    protected final Log logger = LogFactory.getLog(getClass());

    /** t[ID̐ڔ */
    private String flowIdSuffix = DEFAULT_FLOW_ID_SUFFIX;

    /** CfbNXt[ID */
    private String indexFlowId = DEFAULT_INDEX_FLOW_ID;

    /**
     * URIt[ID쐬܂B
     *
     * ɋL܂B
     * URI: /${context path}/dir1/dir2/page.html
     * t[ID̐ڔ: -flow
     * t[ID: dir1/dir2/page-flow
     *
     * @param context {@link ServletExternalContext}
     * @return t[ID
     * @throws IllegalArgumentException context 
     *     {@link ServletExternalContext} łȂ
     */
    @Override
    public String extractFlowId(ExternalContext context)
        throws IllegalArgumentException {

        if (!(context instanceof ServletExternalContext)) {
            String errorMessage = "Context '" + context + "' is not "
                + ServletExternalContext.class.getName() + ".";
            logger.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        ServletExternalContext servletExternalContext
            = (ServletExternalContext) context;
        HttpServletRequest request = servletExternalContext.getRequest();
        String flowId = request.getRequestURI();
        flowId = flowId.substring(request.getContextPath().length());
        String fileName = WebUtils.extractFilenameFromUrlPath(flowId);
        if ("".equals(fileName)) {
            fileName = indexFlowId;
        }
        flowId = flowId.substring(0, flowId.lastIndexOf('/') + 1);
        flowId = flowId.concat(fileName);
        flowId = flowId.concat(flowIdSuffix);
        if (flowId.charAt(0) == '/') {
            flowId = flowId.substring(1);
        }
        return flowId;
    }

}
