package org.unitedfront2.web.controller.mail;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.communication.Mail;
import org.unitedfront2.domain.communication.MailTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.SubflowUtils;
import org.unitedfront2.web.mail.MailSendException;

/**
 * [쐬ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "mail.createAction")
public class CreateAction extends SendMailActionSupport {

    /** [̃[ev[g (mail.Mail-mail) */
    public static final String MAIL_MAIL_TEMPLATE_NAME = "mail.Mail-mail";

    /**
     * 炩߈ݒ肷ۂ́A̕ϐɃ[UIuWFNg܂B̃\bhĂяoۂ́A
     * K킹 {@link #MAIL_PARAM_NAME} ݒ肵Aݒ肵ĂB
     */
    public static final String UNMODIFIABLE_TO_PARAM_NAME = "unmodifiableTo";

    /**
     * e[M̎s𖳎邩ǂ\ϐBȂ <code>true</code> A
     * A܂QƂȂ <code>false</code> BftHg <code>false</code> B
     */
    public static final String IGNORE_EMAIL_FAILURE_PARAM_NAME
        = "ignoreEmailFailure";

    /** [Ue[u */
    @Autowired private SimpleUserTable simpleUserTable;

    /** [e[u */
    @Autowired private MailTable mailTable;

    /** hCt@Ng */
    @Autowired private DomainFactory domainFactory;

    @Override
    protected void initAction() {
        super.initAction();
        setMailTemplateName(MAIL_MAIL_TEMPLATE_NAME);
    }

    /**
     * tH[̏s܂BNGXgp[^ 'code' Ƀ[UR[hݒ肷ƁAɂ̃[
     * Uݒ肳܂B
     *
     * @param context {@link RequestContext}
     * @return {@link Event}
     * @throws Exception {@link Exception}
     */
    @Override
    public Event setupForm(RequestContext context) throws Exception {
        Event event = super.setupForm(context);

        SubflowUtils.setupMessages(context, "mail.CreateForm");

        Mail mail = (Mail) getFormObject(context);

        String toCode = context.getRequestParameters().get("code");
        if (StringUtils.isNotBlank(toCode)) {
            SimpleUser to = simpleUserTable.findByCode(toCode);
            if (to != null) {
                mail.setToId(to.getId());
                mail.setTo(to);
                return event;
            }
        }

        if (mail.getTo() == null) {
            mail.setTo(domainFactory.prototype(SimpleUser.class));
        }

        return event;
    }

    /**
     * eNX <code>doValidate</code> ĂяoAŒw肷ꍇ́A悪ύX
     * ĂȂ؂܂B
     *
     * @param context {@link RequestContext}
     * @param formObject [
     * @param errors {@link Errors}
     * @throws Exception {@link Exception}
     */
    @Override
    protected void doValidate(RequestContext context, Object formObject,
            Errors errors) throws Exception {

        super.doValidate(context, formObject, errors);

        Object unmodifiableTo = context.getFlowScope()
            .get(UNMODIFIABLE_TO_PARAM_NAME);
        if (unmodifiableTo != null) {
            Mail mail = (Mail) formObject;
            if (!mail.getToId().equals(((User) unmodifiableTo).getId())) {
                errors.rejectValue("to", null, "The TO must not be modified.");
                mail.setToId(((SimpleUser) unmodifiableTo).getId());
                mail.setTo((SimpleUser) unmodifiableTo);
                putFormObject(context, mail);
            }
        }
    }

    /**
     * Os܂B悪Œ肳Ăꍇ́AŒ肳ꂽϐ {@link
     * #UNMODIFIABLE_TO_PARAM_NAME} ƂāAt[XR[vɊi[܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event init(RequestContext context) {
        Object unmodifiableTo = context.getFlowScope()
            .get(UNMODIFIABLE_TO_PARAM_NAME);
        if (unmodifiableTo == null) {
            return success();
        }
        Object mail = context.getFlowScope().get(MAIL_PARAM_NAME);
        if (mail == null) {
            String message = "The mail must not be null when parameter '"
                + UNMODIFIABLE_TO_PARAM_NAME + "' has been set.";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        Integer toId = ((Mail) mail).getToId();
        if (toId == null) {
            String message = "The TO must not be null when parameter '"
                + UNMODIFIABLE_TO_PARAM_NAME + "' has been set.";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        context.getFlowScope().put(UNMODIFIABLE_TO_PARAM_NAME,
            simpleUserTable.get(toId));
        return success();
    }

    /**
     * [𑗐M܂BoĺAZbVɊi[ĂAJEgIuWFNg̎ɂȂ܂B
     * AOC[Uɂ鑀̏ꍇ͍olȂőM܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws UserNotFoundException [UȂ
     */
    public Event send(RequestContext context) throws UserNotFoundException {
        Mail mail = (Mail) getFormObject(context);

        SimpleUser to = simpleUserTable.findByName(mail.getTo().getName());
        mail.setTo(to);
        mail.setToId(to.getId());

        Account account = WebUtils.findAccount(context);
        if (account != null) {
            // AN^[[UȂ炻̃[Uol
            mail.setFromId(account.getId());
        }
        mail.send();

        if (isSendMail()) {
            mail.retrieveToMailAddr();
        }

        mail.setFrom(WebUtils.findUser(context));
        context.getRequestScope().put(MAIL_PARAM_NAME, mail);

        if (isSendMail() && mailTable.isForwarding(mail.getToId())) {
            try {
                doSendMail(context);
            } catch (MailSendException e) {
                logger.error(e.getMessage(), e);
                Object o = context.getFlowScope().get(
                        IGNORE_EMAIL_FAILURE_PARAM_NAME);
                if (o != null && Boolean.valueOf(o.toString())) {
                    // O𖳎
                    logger.info("The exception '" + e.getMessage()
                            + "' is ignored.");
                } else {
                    throw new IllegalStateException(e);
                }
            }
        }

        return success();
    }

    @Override
    @Resource(name = "mail.createValidator")
    public void setValidator(Validator validator) {
        super.setValidator(validator);
    }
}
