package org.unitedfront2.web.controller.community;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityTable;
import org.unitedfront2.domain.communication.Thread;
import org.unitedfront2.domain.communication.Thread.Status;
import org.unitedfront2.web.flow.BadRequestException;

/**
 * Xbh̃Xe[^XύXANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "community.threadStatusUpdateAction")
public class ThreadStatusUpdateAction extends AbstractAction {

    /** R~jeBe[u */
    @Autowired
    private CommunityTable communityTable;

    @Override
    protected Event doExecute(RequestContext context) {
        Community c = Utils.findCommunity(context, this, communityTable,
                "communityCode");
        Thread t = Utils.findThreadAndWriteAccess(context, this, c, "threadId");

        updateStatus(context, t);

        context.getFlowScope().put("community", c);
        context.getFlowScope().put("thread", t);
        return success();
    }

    private void updateStatus(RequestContext context, Thread thread) {
        String strStatus = context.getRequestParameters().getRequired("status");
        if (!Status.contains(strStatus)) {
            String message = "The status '" + strStatus + "' not supported.";
            logger.warn(message);
            throw new BadRequestException(context, this, message);
        }
        Status status = Status.valueOf(strStatus);
        thread.setStatus(status);
        thread.store();
    }
}
