package org.unitedfront2.web.controller.community;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.CommunityTable;
import org.unitedfront2.domain.communication.MultiThreadCommunity;
import org.unitedfront2.domain.communication.Thread;

/**
 * Xbh폜@\̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "community.threadDeleteAction")
public class ThreadDeleteAction extends AbstractAction {

    /** R~jeBe[u */
    @Autowired
    private CommunityTable communityTable;

    @Override
    protected Event doExecute(RequestContext context) throws Exception {
        MultiThreadCommunity c = Utils.findMultiThreadCommunity(context, this,
                communityTable, "communityCode");
        Thread t = Utils.findThreadAndWriteAccess(context, this, c, "threadId");

        t.delete();

        context.getFlowScope().put("community", c);
        return success();
    }
}
