package org.unitedfront2.web.controller.community;

import java.util.List;

import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.preparer.PreparerException;
import org.apache.tiles.preparer.ViewPreparer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityTable;

/**
 * JR~jeBEBWFbgp {@link ViewPreparer} łB
 *
 * @author kurokkie
 *
 */
@Repository(value = "community.publicCommunitiesWidgetPreparer")
public class PublicCommunitiesWidgetPreparer implements ViewPreparer {

    /** ő\ (10) */
    public static final int MAX = 10;

    /** R~jeBe[u */
    @Autowired
    private CommunityTable communityTable;

    @Override
    public void execute(TilesRequestContext tilesContext,
            AttributeContext attributeContext) throws PreparerException {
        List<Community> communities = communityTable
            .findPublicCommunitiesRandomly(MAX);
        attributeContext.putAttribute("communities",
                new Attribute(communities));
    }
}
